# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from params.winpos import WIN_POS
from scenes.setting_mii.mii_editor import MiiEditor
from testcases.examples.utility import touch_bar_point_percent_of

from kiki.util.log import file_logger as logger
from res.res_path import RES_PATH

_ICON_IMAGE_PATH = RES_PATH + "/setting_mii/"

class MiiMouthEditor(MiiEditor):
    def __init__(self, driver):
        super(MiiMouthEditor, self).__init__(driver)

    def select_mouth_parts(self,id):
        id_pos = {
            0:[130,210],
            1:[230,210],
            2:[330,210],
            3:[430,210],
            4:[530,210],
            5:[630,210],
            6:[130,290],
            7:[230,290],
            8:[330,290],
            9:[430,290],
            10:[530,290],
            11:[630,290],
            12:[130,370],
            13:[230,370],
            14:[330,370],
            15:[430,370],
            16:[530,370],
            17:[630,370],
            18:[130,450],
            19:[230,450],
            20:[330,450],
            21:[430,450],
            22:[530,450],
            23:[630,450],
            24:[130,530],
            25:[230,530],
            26:[330,530],
            27:[430,530],
            28:[530,530],
            29:[630,530],
            30:[130,610],
            31:[230,610],
            32:[330,610],
            33:[430,610],
            34:[530,610],
            35:[630,610],
        }

        self.driver.screen.touch(0,x= 210,y= 85, ms_after=500)
        self.driver.screen.touch(0,x= id_pos[id][0],y= id_pos[id][1], ms_after=500)

    def select_mouth_placement(self,placement_info):
        # 口の配置の設定値を上から順にリストでもらい、該当する引数のレベルの位置をタッチする
        #percentage = argument / argument_num
        #touch_bar_point_percent_of(self.driver,start_x=252,start_y=215,angle=0,bar_length=256,percentage=percentage)
        self.driver.screen.touch(0,x= 380,y= 85, ms_after=500)

        arg = placement_info
        max_arg = [18,8,6]
        percentages =[]
        for n in range(len(arg)):
            if arg[n] is not None :
                percentages.append(arg[n] / max_arg[n])
            else:
                percentages.append(arg[n])

        bar_y_pos =260
        for x in percentages:
            if x is not None: # きぐちが追加しました…があってますか？
                touch_bar_point_percent_of(self.driver,start_x=252,start_y=bar_y_pos,angle=0,bar_length=256,percentage=x)
            bar_y_pos += 80


    def set_mouth_settings(self,mouth_parts_id,mouth_pos,mouth_size,mouth_height,mouth_color_id):
        mouth_placement = [mouth_pos,mouth_size,mouth_height]
        if mouth_parts_id is not None : self.select_mouth_parts(mouth_parts_id)
        self.select_mouth_placement(mouth_placement)
        if mouth_color_id is not None : self.select_color_of_parts(mouth_color_id)
        self.back_to_edit_menu()

