# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from params.winpos import WIN_POS
from scenes.setting_mii.mii_editor import MiiEditor

from kiki.util.log import file_logger as logger
from res.res_path import RES_PATH



_ICON_IMAGE_PATH = RES_PATH + "/setting_mii/"





class MiiFaceEditor(MiiEditor):
    def __init__(self, driver):
        super(MiiFaceEditor, self).__init__(driver)

    def is_available(self):
        return True

    def _search_icon_from_image_list(self, icon_image_list, threshold=0.8, shows_result=False):
        """ 画像のリストのうち、一つでもヒットしたらその場所を返す

        :param icon_image_list:
        :param shows_result:
        :return:
        """
        for icon_image in icon_image_list:
            result = self.driver.screen.detect_object_with_image(icon_image, threshold=threshold, shows_result=shows_result)
            if result is not None:
                logger.debug(u"[search_icon_from_image_list]アイコン発見")
                return result[0], result[1]

    def select_face_outline(self,id):
        id_pos = {
            0:[230,300],
            1:[330,300],
            2:[430,300],
            3:[530,300],
            4:[230,400],
            5:[330,400],
            6:[430,400],
            7:[530,400],
            8:[230,500],
            9:[330,500],
            10:[430,500],
            11:[530,500]
        }
        self.driver.screen.touch(0,x= 180,y= 85, ms_after=500)
        self.driver.screen.touch(0,x= id_pos[id][0],y= id_pos[id][1], ms_after=500)


    def select_face_cheek(self,id):
        id_pos = {
            0:[230,300],
            1:[330,300],
            2:[430,300],
            3:[530,300],
            4:[230,400],
            5:[330,400],
            6:[430,400],
            7:[530,400],
            8:[230,500],
            9:[330,500],
            10:[430,500],
            11:[530,500]
        }
        self.driver.screen.touch(0,x= 280,y= 85, ms_after=500)
        self.driver.screen.touch(0,x= id_pos[id][0],y= id_pos[id][1], ms_after=500)


    def select_face_wrinkle(self,id):
        id_pos = {
            0:[230,300],
            1:[330,300],
            2:[430,300],
            3:[530,300],
            4:[230,400],
            5:[330,400],
            6:[430,400],
            7:[530,400],
            8:[230,500],
            9:[330,500],
            10:[430,500],
            11:[530,500]
        }
        self.driver.screen.touch(0,x= 380,y= 85, ms_after=500)
        self.driver.screen.touch(0,x= id_pos[id][0],y= id_pos[id][1], ms_after=500)


    def select_face_color(self,id):
        id_pos = {
            0:[218,340],
            1:[298,340],
            2:[378,340],
            3:[458,340],
            4:[538,340],
            5:[218,400],
            6:[298,400],
            7:[378,400],
            8:[458,500],
            9:[538,500],
        }

        self.driver.screen.touch(0,x= 530,y= 85, ms_after=500)
        self.driver.screen.touch(0,x= id_pos[id][0],y= id_pos[id][1], ms_after=500)

    def set_face_settings(self,outline_id,cheek_id,wrinkle_id,color_id):

        if outline_id is not None : self.select_face_outline(outline_id)
        if cheek_id is not None : self.select_face_cheek(cheek_id)
        if wrinkle_id is not None : self.select_face_wrinkle(wrinkle_id)
        if color_id is not None : self.select_face_color(color_id)
        self.back_to_edit_menu()

    """
    def select_face_outline_icon(self,face_outline_id):

        face_outline_id_pos = {
            "1":[230,300,[_ICON_IMAGE_PATH + "face_outline_id_1_on.PNG",
                          _ICON_IMAGE_PATH + "face_outline_id_1_off.PNG"]],
            "2":[330,300,[_ICON_IMAGE_PATH + "face_outline_id_2_on.PNG",
                          _ICON_IMAGE_PATH + "face_outline_id_2_off.PNG"]],
            "3":[430,300,[_ICON_IMAGE_PATH + "face_outline_id_3_on.PNG",
                          _ICON_IMAGE_PATH + "face_outline_id_3_off.PNG"]],
            "4":[530,300,[_ICON_IMAGE_PATH + "face_outline_id_4_on.PNG",
                          _ICON_IMAGE_PATH + "face_outline_id_4_off.PNG"]],
            "5":[230,400,[_ICON_IMAGE_PATH + "face_outline_id_5_on.PNG",
                          _ICON_IMAGE_PATH + "face_outline_id_5_off.PNG"]],
            "6":[330,400,[_ICON_IMAGE_PATH + "face_outline_id_6_on.PNG",
                          _ICON_IMAGE_PATH + "face_outline_id_6_off.PNG"]],
            "7":[430,400,[_ICON_IMAGE_PATH + "face_outline_id_7_on.PNG",
                          _ICON_IMAGE_PATH + "face_outline_id_7_off.PNG"]],
            "8":[530,400,[_ICON_IMAGE_PATH + "face_outline_id_8_on.PNG",
                          _ICON_IMAGE_PATH + "face_outline_id_8_off.PNG"]],
            "9":[230,500,[_ICON_IMAGE_PATH + "face_outline_id_9_on.PNG",
                          _ICON_IMAGE_PATH + "face_outline_id_9_off.PNG"]],
            "10":[330,500,[_ICON_IMAGE_PATH + "face_outline_id_10_on.PNG",
                          _ICON_IMAGE_PATH + "face_outline_id_10_off.PNG"]],
            "11":[430,500,[_ICON_IMAGE_PATH + "face_outline_id_11_on.PNG",
                          _ICON_IMAGE_PATH + "face_outline_id_11_off.PNG"]],
            "12":[530,500,[_ICON_IMAGE_PATH + "face_outline_id_12_on.PNG",
                          _ICON_IMAGE_PATH + "face_outline_id_12_off.PNG"]]
        }
        # pos だけでよかった、仕様変更とかがない限りは特に座標だけでいいのでは？
        self.driver.screen.touch(0,x= 180,y= 85, ms_after=500)

        images = face_outline_id_pos[face_outline_id][2]
        result_pos = self._search_icon_from_image_list(icon_image_list=images, threshold=0.99, shows_result=True)
        if result_pos is not None:
                print(result_pos)
                self.driver.screen.touch(0,x= result_pos[0]+20,y= result_pos[1]+20, ms_after=500)
                return True

        else:
            logger.debug(u"[]指定した輪郭のアイコンid="+face_outline_id+"が見つかりませんでした")

    def select_face_cheek_icon(self,face_cheek_id):

        face_cheek_id_pos = {
            "1":[230,300,[_ICON_IMAGE_PATH + "face_cheek_id_1_on.PNG",
                          _ICON_IMAGE_PATH + "face_cheek_id_1_off.PNG"]],
            "2":[330,300,[_ICON_IMAGE_PATH + "face_cheek_id_2_on.PNG",
                          _ICON_IMAGE_PATH + "face_cheek_id_2_off.PNG"]],
            "3":[430,300,[_ICON_IMAGE_PATH + "face_cheek_id_3_on.PNG",
                          _ICON_IMAGE_PATH + "face_cheek_id_3_off.PNG"]],
            "4":[530,300,[_ICON_IMAGE_PATH + "face_cheek_id_4_on.PNG",
                          _ICON_IMAGE_PATH + "face_cheek_id_4_off.PNG"]],
            "5":[230,400,[_ICON_IMAGE_PATH + "face_cheek_id_5_on.PNG",
                          _ICON_IMAGE_PATH + "face_cheek_id_5_off.PNG"]],
            "6":[330,400,[_ICON_IMAGE_PATH + "face_cheek_id_6_on.PNG",
                          _ICON_IMAGE_PATH + "face_cheek_id_6_off.PNG"]],
            "7":[430,400,[_ICON_IMAGE_PATH + "face_cheek_id_7_on.PNG",
                          _ICON_IMAGE_PATH + "face__id_7_off.PNG"]],
            "8":[530,400,[_ICON_IMAGE_PATH + "face_outline_id_8_on.PNG",
                          _ICON_IMAGE_PATH + "face_outline_id_8_off.PNG"]],
            "9":[230,500,[_ICON_IMAGE_PATH + "face_outline_id_9_on.PNG",
                          _ICON_IMAGE_PATH + "face_outline_id_9_off.PNG"]],
            "10":[330,500,[_ICON_IMAGE_PATH + "face_outline_id_10_on.PNG",
                          _ICON_IMAGE_PATH + "face_outline_id_10_off.PNG"]],
            "11":[430,500,[_ICON_IMAGE_PATH + "face_outline_id_11_on.PNG",
                          _ICON_IMAGE_PATH + "face_outline_id_11_off.PNG"]],
            "12":[530,500,[_ICON_IMAGE_PATH + "face_outline_id_12_on.PNG",
                          _ICON_IMAGE_PATH + "face_outline_id_12_off.PNG"]]
        }

        self.driver.screen.touch(0,x= 280,y= 85, ms_after=500)

        images = face_cheek_id_pos[face_cheek_id][2]
        result_pos = self._search_icon_from_image_list(icon_image_list=images, threshold=0.99, shows_result=True)
        if result_pos is not None:
                print(result_pos)
                self.driver.screen.touch(0,x= result_pos[0]+20,y= result_pos[1]+20, ms_after=500)
                return True

        else:
            logger.debug(u"[]指定した輪郭のアイコンid="+face_cheek_id+"が見つかりませんでした")
        """
