# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

from params.winpos import WIN_POS
from scenes.setting_mii.mii_editor import MiiEditor
from testcases.examples.utility import touch_bar_point_percent_of
from kiki.util.log import file_logger as logger

class MiiEyesEditor(MiiEditor):
    def __init__(self, driver):
        super(MiiEyesEditor, self).__init__(driver)


    def select_eyes_parts(self,id):
        id_pos ={
            0:[150,235],
            1:[242,235],
            2:[334,235],
            3:[426,235],
            4:[518,235],
            5:[610,235],
            6:[150,320],
            7:[242,320],
            8:[334,320],
            9:[426,320],
            10:[518,320],
            11:[610,320],
            12:[150,410],
            13:[242,410],
            14:[334,410],
            15:[426,410],
            16:[518,410],
            17:[610,410],
            18:[150,500],
            19:[242,500],
            20:[334,500],
            21:[426,500],
            22:[518,500],
            23:[610,500],
            24:[150,595],
            25:[242,595],
            26:[334,595],
            27:[426,595],
            28:[518,595],
            29:[610,595],
        }

        self.driver.screen.touch(0,x=270 ,y= 85 ,ms_after = 500)

        page_id_pos = 335 + 50 * int(id / 30)
        self.driver.screen.touch(0,x=60 ,y= page_id_pos ,ms_after = 500)

        icon_id = id % 30
        self.driver.screen.touch(0,x=id_pos[icon_id][0],y=id_pos[icon_id][1], ms_after=500)


    def select_eyes_placement(self,placement_info):
        # 目の配置の設定値を上から順にリストでもらい、該当する引数のレベル（パーセンテージ）の位置をタッチする
        #percentage = argument / argument_num
        #touch_bar_point_percent_of(self.driver,start_x=252,start_y=215,angle=0,bar_length=256,percentage=percentage)
        self.driver.screen.touch(0,x= 380,y= 85, ms_after=500)

        arg = placement_info
        max_arg = [18,12,7,7,6]
        percentages = []
        for n in range(len(arg)):
            if arg[n] is not None :
                percentages.append(arg[n] / max_arg[n])
            else:
                percentages.append(arg[n])

        bar_y_pos =190
        for x in percentages:
            if x is not None:
                touch_bar_point_percent_of(self.driver,start_x=252,start_y=bar_y_pos,angle=0,bar_length=256,percentage=x)
            bar_y_pos += 80


    def set_eyes_settings(self,eyes_parts_id,eyes_pos,eyes_width,eyes_incline,eyes_size,eyes_height,eyes_color_id):
        eyes_placement = [eyes_pos,eyes_width,eyes_incline,eyes_size,eyes_height]
        if eyes_parts_id is not None:self.select_eyes_parts(eyes_parts_id)
        self.select_eyes_placement(eyes_placement)
        if eyes_parts_id is not None:self.select_color_of_parts(eyes_color_id)
        self.back_to_edit_menu()

