# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals


import time

from scenes.base_scene import BaseScene
from res.res_path import RES_PATH

from kiki.util.log import file_logger as logger

_ICON_IMAGE_PATH = RES_PATH + "/home_menu/"

class SandBox(BaseScene):
    def __init__(self, driver):
        super(SandBox, self).__init__(driver)

    def is_available(self):
        sandbox_menu = _ICON_IMAGE_PATH + "sandbox_menu.png"
        if self.driver.window.detect_object(sandbox_menu) is not None:
            return True
        else:
            return False

    def return_to_home(self):
        from scenes.home_menu.home_menu import HomeMenu

        self.driver.controllers[0].push("START", ms_after=2000) # TODO: HOMEボタン実装されたら変える
        return HomeMenu(driver=self.driver)