# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals


import time

from res.res_path import RES_PATH
from scenes.t_base_scene import TBaseScene

_ICON_IMAGE_PATH = RES_PATH + "/friend/"


class TMypage(TBaseScene):
    def __init__(self, driver):
        super(TMypage, self).__init__(driver)

    def is_available(self):
        image = _ICON_IMAGE_PATH + "ss_mypage_header.png"

        for i in range(10):
            if self.driver.screen.detect_object_with_image(image) is not None:
                return True
            else:
                time.sleep(1)
        return False

    def is_available_profile(self):
        image = _ICON_IMAGE_PATH + "ss_mypage_profile.png"

        for i in range(30):
            if self.driver.screen.detect_object_with_image(image) is not None:
                return True
            else:
                time.sleep(1)
        return False

    def select_navi_bar(self, name, id=0):
        name_dict = { "プロフィール": 0,
                      "フレンドリスト": 1,
                      "フレンドになれるかも？": 2,
                      "フレンド追加": 3,
                      "ユーザー設定": 4 }

        # 前回終了時の選択を記憶しているのでプロフィールまで一度戻す
        self.driver.controllers[id].push("UP", ms_press=1500, ms_after=1000)

        # profile 画面を選択する場合にはロードが完了するのを待つ
        if name == "プロフィール":
            self.is_available_profile()

        for i in range(name_dict[name]):
            self.driver.controllers[id].push("DOWN", ms_after=500)

        self.driver.controllers[id].push("A", ms_after=1000)

    def select_app_from_play_log(self, app_img_paths, id=0):
        # プロフィール / フレンド詳細のどちらでも使用可
        # あらかじめカーソル位置は右側へ送っておくこと
        # detect_object で使用する教師画像のパスを受け取る 文字列型 or リスト型
        image = []
        if type(app_img_paths) == list:
            for img_path in app_img_paths:
                image.append(img_path)
        else:
            image.append(app_img_paths)

        # カーソル位置を最上部へ
        self.driver.controllers[id].push("UP", ms_press=1000, ms_after=1000)

        for i in range(10): # とりあえず10回。
            self.driver.controllers[id].push("DOWN", ms_after=500)
            for trg in image:
                if self.driver.screen.detect_object_with_image(trg) is not None:
                    self.driver.controllers[id].push("A", ms_after=1000)
                    return True
        return False

    def is_NA_linked_user(self):
        # マイページ遷移後から
        self.select_navi_bar("プロフィール")

        image = _ICON_IMAGE_PATH + "NA_linked_friend_code.png"
        if self.driver.screen.detect_object_with_image(image) is not None:
            return True
        else:
            return False

    def is_available_block_list(self):
        image = _ICON_IMAGE_PATH + "block_list_identity.png"
        for i in range(10):
            if self.driver.screen.detect_object_with_image(image) is not None:
                return True
        else:
            return False