# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals


import time

from res.res_path import RES_PATH
from scenes.base_scene import BaseScene
from scenes.common.swkbd import Swkbd

_ICON_IMAGE_PATH = RES_PATH + "/cruiser/"

class Cruiser(BaseScene):
    def __init__(self, driver):
        super(Cruiser, self).__init__(driver)

    def is_available(self):
        pass

    def is_available_NA_login_page(self):
        icon_image_list = [
                           _ICON_IMAGE_PATH + "ss_mail_icon.png"
                            ]

        for icon_image in icon_image_list:
            if self.driver.screen.detect_object_with_image(icon_image) is not None:
                return True
        else:
            return False

    def search_icon(self, name, threshold=0.8, shows_result=False):
        if type(name) == list:
            for image_name in name:
                icon_image = _ICON_IMAGE_PATH + image_name
                icon = icon_image
                result = self.driver.screen.detect_object_with_image(icon, threshold=threshold, shows_result=shows_result)
                if result is not None:
                    return result[0], result[1]
            return None
        else:
            icon_image = _ICON_IMAGE_PATH + name
            icon = icon_image
            result = self.driver.screen.detect_object_with_image(icon, threshold=threshold, shows_result=shows_result)
            if result is not None:
                return result[0], result[1]
            else:
                return None

    def input_created_NA_info(self, id, password, driver, language, logstore):
        # メールアドレスまたはユーザーIDでログイン を選択した先の画面から、
        # ID/PASS の保存する・しないの表示まで。
        self.driver.controllers[0].push("A", ms_after=500)
        scene = Swkbd(driver)
        scene.swkbd_input_str(id, language, logstore)
        scene.swkbd_input_enter()
        time.sleep(1)
        scene.swkbd_input_str(password, language, logstore)
        scene.swkbd_input_enter()
