# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

import time

from params.winpos import WIN_POS
from scenes.base_scene import BaseScene
from kiki.util.log import file_logger as logger
from scenes.common.swkbd import Swkbd


class AlbumEdit(BaseScene):
    def __init__(self, driver):
        super(AlbumEdit, self).__init__(driver)
        self.swkbd = Swkbd(driver)

    def is_available(self):
        # 「テキスト入力」は遷移した直後の画面が SWKBD
        pass

    def set_cursor_at_size_buttons(self, id=0):
        # 文字サイズの選択状況に影響しないよう、
        # サイズの3つのボタンのどれかにカーソルが合わされている状態にする
        # 要 UP 4回 + 少し余分に押させる
        for i in range(5):
            self.driver.controllers[id].push("UP")

    def input_str(self, str):
        # swkbd_input_strを使わせてもらう予定
        self.swkbd.swkbd_input_str(str)
        self.swkbd.swkbd_input_enter()

    def change_font_size(self, size, id=0):
        # sizeは左から 0, 1, 2 ? Large, Medium, Small ?
        # キー操作で実装してみよう

        # カーソル位置の初期化
        self.set_cursor_at_size_buttons()

        for i in range(4):
            self.driver.controllers[id].push("LEFT")

        size_list = {
            "Large": 1,
            "Medium": 2,
            "Small": 3
        }

        num = size_list[size]
        for i in range(num):
            self.driver.controllers[id].push("RIGHT")

        """タッチ操作の練習の名残。
        if size == "Large":
            self.driver.screen.touch(0, 1020, 100, ms_press=2000)
        elif size == "Medium":
            self.driver.screen.touch(0, 1100, 100, ms_press=2000)
        elif size == "Small":
            self.driver.screen.touch(0, 1180, 100, ms_press=2000)
        time.sleep(1)
         """

    def change_position_and_angle(self, x_pos, y_pos, angle, btn, id=0):

        # 位置と角度 の変更

        self.set_cursor_at_size_buttons()
        self.driver.controllers[id].push("DOWN")
        self.driver.controllers[id].push("A")
        time.sleep(1)

        self.driver.screen.touch(0, x_pos, y_pos, ms_after=500)

        if angle < 0:
            logger.info("角度にマイナスの値が指定されている為、角度変更をスキップします。")
            self.driver.controllers[id].push("B")
            return

        num = angle // 15
        for i in range(num):
            self.driver.controllers[id].push(btn, ms_after=300)

        self.driver.controllers[id].push("B")

    def change_color(self, color, id=0):
        # 色の変更
        # 色の種類は今のところ 11種

        color_list = {
            "White": 0,
            "Black": 1,
            "Red": 2,
            "Pink": 3,
            "Orange": 4,
            "Yellow": 5,
            "LightGreen": 6,
            "Green": 7,
            "LightBlue": 8,
            "Blue": 9,
            "Purple": 10
        }

        # カーソル位置の初期化
        self.set_cursor_at_size_buttons()

        for i in range(2):
            self.driver.controllers[id].push("DOWN")

        for i in range(12):
            self.driver.controllers[id].push("LEFT")

        time = color_list[color]
        for i in range(time):
            self.driver.controllers[id].push("RIGHT")

    def input_text(self, input_info_list, id=0):
        """input_info_listの中身
        [str, size, x_pos, y_pos, angle, btn, color]
        """

        self.input_str(input_info_list[0])
        self.change_font_size(input_info_list[1])
        self.change_position_and_angle(input_info_list[2], input_info_list[3], input_info_list[4], input_info_list[5])
        self.change_color(input_info_list[6])

    def select_dekiagari(self, id=0):
        # できあがりボタンを選択する
        for i in range(5):
            self.driver.controllers[id].push("DOWN")
        self.driver.controllers[id].push("A")


    def text_exit_flow(self):
        # できあがりボタンの選択はこの関数からは呼ばない
        pass

