# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals


import time

from scenes.album.album_edit import AlbumEdit
from scenes.base_scene import BaseScene
from res.res_path import RES_PATH
from params.winpos import WIN_POS
from kiki.util.log import file_logger as logger
from scenes.main_setting.main_setting import MainSetting

_ICON_IMAGE_PATH = RES_PATH + "/album/"


class Album(BaseScene):
    def __init__(self, driver):
        super(Album, self).__init__(driver)
        self.edit = AlbumEdit(driver)

    def is_available(self):
        setting_icon = _ICON_IMAGE_PATH + "album.png"
        if self.driver.screen.detect_object_with_image(setting_icon) is not None:
            return True
        else:
            return False

    def is_available_from_log(self,logstore):
        #直前のログを確認してアルバム遷移時に発生するログがあるか確認する
        logger.info("Start read_line_until")
        match = logstore.read_line_until(reg_str="\<photoViewer\>.*approveInitialDraw"
                                         , ms_timeout=10000)
        if match is not None:
            print(match.string)
            return True
        else:
            print("matching timeout")
            return False

    def search_icon(self, name):
        if type(name) == list:
            for image_name in name:
                icon_image = _ICON_IMAGE_PATH + image_name
                icon = icon_image
                result = self.driver.screen.detect_object_with_image(icon)
                if result is not None:
                    return result[0], result[1]
            return None
        else:
            icon_image = _ICON_IMAGE_PATH + name
            icon = icon_image
            result = self.driver.screen.detect_object_with_image(icon)
            if result is not None:
                return result[0], result[1]
            else:
                return None

    def check_inserted_microSD(self, logstore, is_reverse=False):
        # 遷移直後は is_available_from_log で目当てのログより下にポインタが移動している可能性が高い。
        logger.info("ログからmicroSDの有無を確認します")

        if is_reverse:
            # 遡って調べるので、ポインタ最新へ。
            logstore.move_pointer_newest()

        match = logstore.read_line_until(reg_str="\<photoViewer\>.*Sd: fileNum\[\d+\] result.*",
                                         ms_timeout=10000, is_reverse=is_reverse)

        if match is not None:
            # is_reverse=True で確認している場合、ポインタがいくつか遡るので最新へ。
            logstore.move_pointer_newest()
            logger.info("SDカード：有")
            return True
        else:
            # ログ読めない問題と切り分けたいので、NANDも調べる
            if not is_reverse:
                # 10行遡る
                logstore.curr_pointer -= 10
            match = logstore.read_line_until(reg_str="\<photoViewer\>.*Nand: fileNum\[\d+\] result.*",
                                             ms_timeout=10000)

            # is_reverse=True で確認している場合、ポインタがいくつか遡るので最新へ。
            logstore.move_pointer_newest()

            if match is not None:
                logger.info("SDカード：無")
                return False
            else:
                # ログ読めてない可能性が高い。
                return None

    def is_any_image(self):
        image = _ICON_IMAGE_PATH + "ss_any_screenshot.png"
        if self.driver.screen.detect_object_with_image(image) is not None:
            return True
        else:
            return False

    def get_current_image_num(self, logstore):
        # ログから NAND/SD に保存されている画像の枚数の合計を出して、int で返す
        # ログに出力される順番は NAND -> SD
        nand_num = self.get_current_NAND_image_num(logstore)
        microSD_num = self.get_current_microSD_image_num(logstore, ms_timeout=3000)
        # print(nand_num, microSD_num)

        if nand_num == -1 and microSD_num == -1: # ログ読めてない。
            return -1
        elif microSD_num == -1: # microSD 刺さってない。
            return nand_num
        else:
            return nand_num + microSD_num

    def get_current_microSD_image_num(self, logstore, ms_timeout=10000, is_reverse=False):
        # ログから SD に保存されている画像の枚数を出して、int で返す
        match = logstore.read_line_until(reg_str="\<photoViewer\>.*getImageFileNum 1 \d+",
                                          ms_timeout=ms_timeout, is_reverse=is_reverse)
        if match is not None:
            images = match.string.split(" ")
            return int(images[4])
        else:
            # SDが刺さってないときは ログに出ない。or ログ読めてない。-1を返す。
            return -1

    def get_current_NAND_image_num(self, logstore, ms_timeout=10000, is_reverse=False):
        # ログから NAND に保存されている画像の枚数を出して、int で返す
        match = logstore.read_line_until(reg_str="\<photoViewer\>.*getImageFileNum 0 \d+",
                                          ms_timeout=ms_timeout, is_reverse=is_reverse)
        if match is not None:
            images = match.string.split(" ")
            return int(images[4])
        else:
            # ログが読めなかった。 -1 を返す。
            return -1

    def exit_album(self):
        # アルバムから出る
        pass

    def page_scroll_to_top(self, ms_press=2000, id=0):
        repeat_num = 15
        x_pos = 1265
        y_pos = 88
        color = (215, 215, 215)

        for i in range(repeat_num):
            self.driver.controllers[id].stick_L(degree=90, ms_press=ms_press, ms_after=800)

            # 一覧画面と、えらんで消去画面とでスクロールバーの色が、若干違った(2ずつ)…
            # ので、color_rangeで幅を持たせています。
            if self.driver.screen.check_color_dot(x_pos, y_pos, color, color_range=3):
                break

    def set_cursor_at_initial_point(self, id=0):
        # スクロールバーの一番上の部分の座標の色を調べて判定する
        # openCV 使えば出来るそう。

        self.page_scroll_to_top()

        for i in range(6):
            self.driver.controllers[id].push("UP", ms_after=500)

        for i in range(6):
            self.driver.controllers[id].push("LEFT", ms_after=500)

    def get_cursor_position_from_image_id(self, img_id):
        # 画像の番目(id)から、row, col を返す

        col_num = 5

        return img_id // col_num, img_id % col_num

    def set_cursor_at_nth_image(self, num, id=0):
        # 0枚目の画像から数えて n番目の画像にカーソル合わせるだけ

        row, col = self.get_cursor_position_from_image_id(num)

        for i in range(row):
            self.driver.controllers[id].push("DOWN", ms_after=300)

        for i in range(col):
            self.driver.controllers[id].push("RIGHT", ms_after=300)

    def select_image(self, id=0):
        # ボタン操作の時はカーソル合わせてAボタンを押さないと拡大画面へ遷移しない。
        # タッチ操作の時はタッチしただけで拡大画面へ遷移する。

        # 拡大画面遷移後 5秒くらいは [B もどる A 投稿や編集] の表示
        # それ以上経過すると [A 決定] の表示となり、A選択時の挙動が異なる

        self.driver.controllers[id].push("A", ms_after=900)

    def return_to_image_list(self, id=0):
        self.driver.controllers[id].push("A", ms_after=500)
        self.driver.controllers[id].push("B", ms_after=500)

    def select_detail_menu(self, menu_name, id=0):
        # 投稿、テキスト入力、コピー、消去
        # B の もどる も要る？
        # テキスト入力の場合、遷移時に枚数チェックが入るメモ(消去 以外何らかのチェックが入る)

        self.driver.controllers[id].push("LEFT", ms_after=500)

        # detail_menu表示
        self.driver.controllers[id].push("A", ms_after=1000)

        for i in range(4):
            self.driver.controllers[id].push("LEFT", ms_after=300)

        img2 = _ICON_IMAGE_PATH + "detail_menu.png"
        self.driver.screen.wait_until_detect_object(img2, limit_count=50)

        menu_list = {
            "post": 0,
            "edit_text": 1,
            "copy": 2,
            "delete": 3
        }

        num = menu_list[menu_name]
        for i in range(num):
            self.driver.controllers[id].push("RIGHT", ms_after=500)

        self.driver.controllers[id].push("A", ms_press=200)

    def execute_single_delete(self):
        # 個別削除の実行
        # タッチの場合
        self.driver.screen.touch(0, x=650, y=600, ms_after=800)

    def select_filtering(self, filter_name, id=0):
        filter_type = {
            "ALL": 0,
            "NAND": 1,
            "SD": 2
        }

        # 絞り込む を選択する
        self.driver.controllers[id].push("Y", ms_after=800)

        filter_index = filter_type[filter_name]
        for i in range(filter_index):
            self.driver.controllers[id].push("DOWN", ms_after=500)
        self.driver.controllers[id].push("A", ms_after=500)

    # =========================
    #   まとめて削除関連
    # =========================

    def select_multi_delete(self, id=0):
        # えらんで消去 を選択する
        self.driver.controllers[id].push("X", ms_after=500)

    def select_multi_images_for_delete(self, image_id_list):
        # 削除するつもりの写真のid をリストでもらい、順番に set_cursor_at_nth_image -> select_image する
        # コントローラで選択するばあい、続けて次の写真を選択するためにカーソル位置の把握か、初期位置に戻す処理が必要

        curr_image_id = 0

        for next_image_id in image_id_list:
            self.select_next_image(curr_image_id, next_image_id)
            self.select_image()
            curr_image_id = next_image_id

    def select_next_image(self, curr_img_id, next_img_id):
        # 今カーソルの合わさってるrow, colを覚える
        curr_row, curr_col = self.get_cursor_position_from_image_id(curr_img_id)

        # 次選ぶべき row, col を計算する
        next_row, next_col = self.get_cursor_position_from_image_id(next_img_id)

        # 差分を出してキー操作で動かす
        #   ▼最終行の画像の枚数は5枚とは限らないので…
        #   次選ぶべき画像が、直近で選んだ画像よりも番目がさかのぼるなら、
        #   row の移動を先にする。
        #   直近で選んだ画像よりも番目が進むなら、col の移動を先にする

        row_num = curr_row - next_row
        if (row_num < 0):
            row_key = "DOWN"
            row_num *= -1
        else:
            row_key = "UP"

        col_num = curr_col - next_col
        if (col_num < 0):
            col_key = "RIGHT"
            col_num *= -1
        else:
            col_key = "LEFT"

        if( curr_img_id > next_img_id ):
            # 直近で選んだ画像よりも番目をさかのぼる
            # row -> col でカーソル移動
            cursor_info_list = [[row_key, row_num], [col_key, col_num]]
        else:
            # 直近で選んだ画像よりも番目を進める
            # col -> row でカーソル移動
            cursor_info_list = [[col_key, col_num], [row_key, row_num]]

        self.set_cursor_for_multi_delete(cursor_info_list)

    def set_cursor_for_multi_delete(self, cursor_info_list, id=0):
        for cursor_info in cursor_info_list:
            for j in range(cursor_info[1]):
                self.driver.controllers[id].push(cursor_info[0], ms_after=400)

    def execute_multi_delete(self):
        #「消去する」を実行する(タッチする？)
        # 続けて確認ダイアログも送る？
        #タッチの場合
        self.driver.screen.touch(0, x=1115, y=560, ms_after=800)
        self.driver.screen.touch(0, x=800, y=450, ms_after=800)
        #コントローラ操作の場合

    def is_displayed_dlg_max_select(self):
        img = _ICON_IMAGE_PATH + "dlg_body_max_select.png"
        if self.driver.screen.detect_object_with_image(img) is not None:
            return True
        else:
            return False

    def is_already_selected(self):
        """ICON_PATH_LIST = [
            _ICON_IMAGE_PATH + "check_icon_with_cursor1.png",
            _ICON_IMAGE_PATH + "check_icon_with_cursor2.png",
            _ICON_IMAGE_PATH + "check_icon_with_cursor3.png"
        ]"""

        ICON_PATH_LIST = [_ICON_IMAGE_PATH + "check_icon_with_cursor01.png"]

        img_list = []
        for icon_path in ICON_PATH_LIST:
            img_list.append(icon_path)

        if self._search_icon_from_image_list(img_list) is not None:
            return True
        else:
            return False

    def is_selected_multi_delete_button(self):
        """ICON_PATH_LIST = [
            _ICON_IMAGE_PATH + "multi_delete_btn_01.png",
            _ICON_IMAGE_PATH + "multi_delete_btn_02.png"
        ]"""

        ICON_PATH_LIST = [_ICON_IMAGE_PATH + "multi_delete_btn01.png"]

        img_list = []
        for icon_path in ICON_PATH_LIST:
            img_list.append(icon_path)

        if self._search_icon_from_image_list(img_list) is not None:
            return True
        else:
            return False

    # =========================
    #   画面遷移
    # =========================
    def return_to_main_setting(self, logstore):
        # 設定の ひとつずつ整理 から scoopViewer へ遷移してきた場合の戻る操作
        logstore.move_pointer_newest()
        self.driver.controllers[0].push("B", ms_after=500)

        reg_str = "\<qlaunch\>.* SetCntDataMng appendChild to N_CntPosNext"
        logger.info("Start read_line_until")
        match = logstore.read_line_until(reg_str=reg_str, ms_timeout=10000)
        if match is not None:
            print(match.string)
            return MainSetting(self.driver)
        else:
            print("matching timeout")
            return None

