# -*- coding: utf-8 -*-
from __future__ import division, print_function, absolute_import, unicode_literals

import os
import sys

from kiki.util.log import kiki_logger as logger

if sys.argv[0].endswith(".exe"):
    LIB_PATH = ".\\lib"
else:
    LIB_PATH = os.path.dirname(__file__)


def reflect_config():
    """
        別のモジュールから読み込まれる前に呼ばれないと意味がない。
        でも循環参照をしないために呼び出しをconfig側で行っている

    :return: None
    """
    from config.confmgr import CONF

    global LIB_PATH
    if CONF.LIB_PATH == LIB_PATH:
        return

    old = LIB_PATH
    LIB_PATH = CONF.LIB_PATH

    logger.info("Config value was reflected.")
    logger.info(old)
    logger.info("↓")
    logger.info(LIB_PATH)


def _reflect_config_for_examples():
    """
        別のモジュールから読み込まれる前に呼ばれないと意味がない。
        でも循環参照をしないために呼び出しをconfig側で行っている

    :return: None
    """
    from examples.config.confmgr import CONF

    global LIB_PATH
    if CONF.LIB_PATH == LIB_PATH:
        return

    old = LIB_PATH
    LIB_PATH = CONF.LIB_PATH

    logger.info("Config value was reflected.")
    logger.info(old)
    logger.info("↓")
    logger.info(LIB_PATH)
