﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstring>
#include <Windows.h>
#include <autoTestAssistTool/LogReaderTypes.h>
#include <autoTestAssistTool/Common/autoTestAssistTool_LibTypes.h>

typedef LogReaderResult (*StartLogStoringFunction)(const SerialNumberString& serialNumber, int logMaxLineCount);
typedef LogReaderResult (*GetLogLineSizeFunction)(size_t* pOutSize);
typedef LogReaderResult (*GetLogLineFunction)(char* buffer, size_t bufferSize);
typedef LogReaderResult (*WaitForNextLineFunction)(int timeoutMs);
typedef LogReaderResult (*WaitUntilMatchedFunction)(const char* regexString, int timeoutMs);
typedef LogReaderResult (*SearchFormerLogFunction)(const char* regexString);
typedef void    (*MoveToNewestLineFunction)();
typedef void    (*MoveToFormerLineByTimeFunction)(int timeMs);
typedef void    (*StopLogStoringFunction)();

typedef LogReaderResult (*MoveToNextLineFunction)();
typedef LogReaderResult (*MoveToPreviousLineFunction)();

class LogReaderWrapper
{
public:
    LogReaderWrapper()
    {
    }

    ~LogReaderWrapper()
    {
        if (m_ModuleHandle != NULL)
        {
            ::FreeLibrary(m_ModuleHandle);
        }
    }

    bool TryLoadLibrary();
    bool TryLoadFunctions();

    StartLogStoringFunction     m_StartLogStoringFunction;
    GetLogLineSizeFunction     m_GetLogLineSizeFunction;
    GetLogLineFunction         m_GetLogLineFunction;
    WaitForNextLineFunction      m_WaitForNextLineFunction;
    WaitUntilMatchedFunction    m_WaitUntilMatchedFunction;
    SearchFormerLogFunction     m_SearchFormerLogFunction;
    MoveToNewestLineFunction    m_MoveToNewestLineFunction;
    MoveToFormerLineByTimeFunction    m_MoveToFormerLineByTimeFunction;
    StopLogStoringFunction      m_StopLogStoringFunction;

    MoveToNextLineFunction      m_MoveToNextLineFunction;
    MoveToPreviousLineFunction  m_MoveToPreviousLineFunction;
private:
    HMODULE m_ModuleHandle;
};
