﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include "TestUtil.h"
#include "HidInputerWrapper.h"

using namespace hidInputer;

// ライブラリ読み込み、解放確認
TEST( HidInputerSuite, LoadLibraryTest)
{
     // Hid ライブラリのラッパークラス
    HidInputerWrapper       hidInputerWrapper;

    // ライブラリ読み込みテスト
    ASSERT_TRUE(hidInputerWrapper.LoadHidLibrary());

    // 関数読み込みテスト
    ASSERT_TRUE(hidInputerWrapper.LoadFunctiontions());

    // 不正な ID 指定による初期化
    const SerialNumberString invalidSerial = { "XAL00000000000" };
    ASSERT_EQ(hidInputerWrapper.m_InitializeFunction(invalidSerial), HidInputerResult::HidInputerResult_TargetNotFound);

    // 正常な ID 指定による初期化
    SerialNumberString serialNumber;
    ASSERT_TRUE(GetTargetSerial(&serialNumber));
    ASSERT_EQ(hidInputerWrapper.m_InitializeFunction(serialNumber), HidInputerResult::HidInputerResult_Success);

    // NX-Win32, NX-x64 アプリケーションに対する初期化
    ASSERT_EQ(hidInputerWrapper.m_InitializeForLocalFunction(), HidInputerResult::HidInputerResult_Success);

    // ライブラリ解放テスト
    ASSERT_TRUE(hidInputerWrapper.ReleaseHidLibrary());
}
