﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <IndirectStorageStream.h>

namespace AuthoringToolsNativeTest
{
    using namespace Nintendo::Authoring::FileSystemMetaLibrary;
    using namespace Microsoft::VisualStudio::TestTools::UnitTesting;

    struct NativeStructType
    {
        int64_t oldOffset;
        int64_t oldSize;
        int64_t newOffset;
        int64_t newSize;
    };

    [TestClassAttribute]
    public ref class IndirectStorageStreamTest
    {
    public:
        [TestMethodAttribute]
        void TestIndirectStorageStreamBinaryMatchHintArrayCanCopyToNativeStructArray()
        {
            static const auto DataCount = 10;

            array<IndirectStorageStream::BinaryMatchHint>^ buffer = gcnew array<IndirectStorageStream::BinaryMatchHint>(DataCount);
            pin_ptr<IndirectStorageStream::BinaryMatchHint> ptr = &buffer[0];

            for( int i = 0; i < DataCount; ++i )
            {
                buffer[i].newOffset = i * 100;
                buffer[i].newSize = i * 200;
                buffer[i].oldOffset = i * 300;
                buffer[i].oldSize = i * 400;
            }

            auto pBuffer = reinterpret_cast<char*>(ptr);

            NativeStructType data[DataCount];
            std::memcpy(data, pBuffer, sizeof(data));

            for( int i = 0; i < DataCount; ++i )
            {
                Int64 expected = i;
                Assert::AreEqual(expected * 100, buffer[i].newOffset);
                Assert::AreEqual(expected * 200, buffer[i].newSize);
                Assert::AreEqual(expected * 300, buffer[i].oldOffset);
                Assert::AreEqual(expected * 400, buffer[i].oldSize);
            }
        }
    };
}
