﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Linq;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Pages;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Test.MainWindow.ProjectEditPanel.Pages
{
    public class LanguagePageVmTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void DefaultCtor()
        {
            using (var vm = _context.DiContainer.GetInstance<LanguagePageVm>())
            {
                Assert.NotEmpty(vm.Params);
                Assert.NotEmpty(vm.SupportedLanguages.AmericaLanguages);
                Assert.NotEmpty(vm.SupportedLanguages.AsiaLanguages);
                Assert.NotEmpty(vm.SupportedLanguages.EuropeLanguages);
            }
        }

        [Fact]
        public void SupportedLanguageHasNoTitle()
        {
            using (var appMeta = _context.DiContainer.GetInstance<ApplicationMeta>())
            using (var vm = _context.DiContainer.GetInstance<LanguagePageVm>())
            {
                appMeta.DiContainer = _context.DiContainer;

                var model =
                    vm.SupportedLanguages.AmericaLanguages.First(x => x.Language.Value == LanguageType.AmericanEnglish);

                Assert.False(model.HasTitle.Value);

                appMeta.Application.Titles.Add(new Title
                {
                    DiContainer = _context.DiContainer,
                    Language = LanguageType.AmericanEnglish,
                });
                Assert.False(model.HasTitle.Value);

                model.IsSupported.Value = true;
                Assert.True(model.HasTitle.Value);
            }
        }
    }
}
