﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Pages;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Test.MainWindow.ProjectEditPanel.Pages
{
    public class FsAccessControlPageVmTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void DefaultCtor()
        {
            using (var vm = _context.DiContainer.GetInstance<FsAccessControlPageVm>())
            {
                Assert.NotEmpty(vm.Params);
            }
        }

        [Fact]
        public void DefaultAccessiblityTypeIsRead()
        {
            using (var vm = _context.DiContainer.GetInstance<FsAccessControlPageVm>())
            {
                vm.SaveDataOwnerIds.AddCommand.Execute();
                var o = vm.SaveDataOwnerIds.SaveDataOwnerIds[0];
                Assert.Equal(new[] {AccessibilityType.Read}, o.Accessibilities.Cast<AccessibilityType>().ToArray());
                Assert.Equal(AccessibilityType.Read, o.Accessibility.Value);
            }
        }

        [Theory]
        [InlineData(AccessibilityType.Read, 1)]
        [InlineData(AccessibilityType.Write, 2)]
        [InlineData(AccessibilityType.ReadWrite, 2)]
        public void IsExistWriteOrReadWriteSelection(AccessibilityType t, int selectionLength)
        {
            using (var project = _context.DiContainer.GetInstance<Project>())
            {
                project.Meta.Core.FsAccessControlData.SaveDataOwnerIds.Add(new SaveDataOwnerId
                {
                    Accessibility = t,
                    ApplicationId = 0x1ul,
                });

                using (var vm = _context.DiContainer.GetInstance<FsAccessControlPageVm>())
                {
                    vm.SaveDataOwnerIds.AddCommand.Execute();
                    var o = vm.SaveDataOwnerIds.SaveDataOwnerIds[0];
                    var selections = o.Accessibilities.Cast<AccessibilityType>().ToArray();
                    Assert.Equal(selectionLength, selections.Length);
                    Assert.Equal(
                        new HashSet<AccessibilityType> {AccessibilityType.Read, t}.ToArray(),
                        selections);
                    Assert.Equal(t, o.Accessibility.Value);
                }
            }
        }
    }
}
