﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Windows.Media;
using Nintendo.Authoring.AuthoringEditor.Core;
using Nintendo.Authoring.AuthoringEditor.MainWindow.ProjectEditPanel.Controls;
using Reactive.Bindings;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Test.MainWindow.ProjectEditPanel.Controls
{
    public class IconActualSizePreviewWindowVmTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void DefaultCtor()
        {
            var brush = new ReactiveProperty<Brush>().ToReadOnlyReactiveProperty();
            using (var vm = new IconActualSizePreviewWindowVm("", new Title(), brush, 2,3))
            {
                Assert.Equal(2, vm.IconWidth);
                Assert.Equal(3, vm.IconHeight);
                Assert.NotNull(vm.CloseCommand);
                Assert.NotNull(vm.Caption);
                Assert.NotNull(vm.IconBrush);
            }
        }

        [Fact]
        public void CloseCommand()
        {
            var brush = new ReactiveProperty<Brush>().ToReadOnlyReactiveProperty();
            using (var vm = new IconActualSizePreviewWindowVm("", new Title(), brush, 2,3))
            {
                vm.CloseCommand.Execute();
            }
        }
    }
}
