﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Reactive.Concurrency;
using System.Threading;
using Reactive.Bindings;

namespace Nintendo.Authoring.AuthoringEditor.Foundation.Test
{
    public class TestContext : IDisposable
    {
        public DisposableDirectory TempDir { get; } = new DisposableDirectory();
        public string TempDirPath => TempDir.RootPath;
        public string RootPath => "../../../../../..";
        public string TestDataDirPath => $"{RootPath}/Tools/Sources/Tests/AuthoringEditorTest/TestData";

        public TestContext()
        {
            CleanTestEnv();
        }

        public void Dispose()
        {
            TempDir.Dispose();
        }

        private static int _isCleaned;

        public static void CleanTestEnv()
        {
            if (Interlocked.Increment(ref _isCleaned) != 1)
                return;

            ReactivePropertyScheduler.SetDefault(ImmediateScheduler.Instance);
        }
    }
}
