﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Core.Test
{
    public class RatingDataTest
    {
        [Fact]
        public void DefaultCtor()
        {
            var r = new RatingData();

            Assert.Null(r.RatingOrganization);
            Assert.Null(r.RegionNames);
            Assert.Null(r.TargetCountryNames);
            Assert.Null(r.Categories);
        }

        [Fact]
        public void Basic()
        {
            // ReSharper disable once ObjectCreationAsStatement
            new RatingData
            {
                RatingOrganization = null,
                RegionNames = null,
                TargetCountryNames = null,
                Categories = null
            };
        }
    }

    public class RatingCategoryDataTest
    {
        [Fact]
        public void DefaultCtor()
        {
            var r = new RatingCategoryData();

            Assert.Null(r.RatingCategory);
            Assert.Equal(0, r.AgeValue);
            Assert.Null(r.Names);
        }


        [Fact]
        public void Basic()
        {
            // ReSharper disable once ObjectCreationAsStatement
            new RatingCategoryData
            {
                RatingCategory = null,
                AgeValue = 0,
                Names = null
            };
        }
    }

}
