﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using Xunit;

namespace Nintendo.Authoring.AuthoringEditor.Core.Test
{
    public class CultureSummryTest : IDisposable
    {
        private readonly TestContext _context = new TestContext();

        public void Dispose()
        {
            _context.Dispose();
        }

        [Fact]
        public void Basic()
        {
            var c = new CultureSummry();

            Assert.Null(c.Caption);
            Assert.Null(c.CultureName);

            c.Caption = "A";
            c.CultureName = "B";

            Assert.Equal("A", c.Caption);
            Assert.Equal("B", c.CultureName);
        }
    }
}
