﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.IO;
using System.Text;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace AppletSequenceTest
{
    [TestClass]
    public class ExcecutionTest
    {
        public TestContext TestContext { get; set; }

        private static string targetName = string.Empty;

        [ClassInitialize]
        public static void TestClassInitialize(TestContext context)
        {
            targetName = (string)context.Properties["TargetName"];
        }

        private bool ExecuteDevMenuCommand(string args)
        {
            var testPath = new TestUtility.TestPath(this.TestContext);

            return ExecuteDevMenuCommandCommon(args, testPath.GetSigloRoot() + "\\Programs\\Eris\\Outputs\\NX-NXFP2-a64\\TargetTools\\DevMenuCommand\\Release\\DevMenuCommand.nsp");
        }

        private bool ExecuteDevMenuCommandSystem(string args)
        {
            var testPath = new TestUtility.TestPath(this.TestContext);

            return ExecuteDevMenuCommandCommon(args, testPath.GetSigloRoot() + "\\Programs\\Eris\\Outputs\\NX-NXFP2-a64\\TargetTools\\DevMenuCommandSystem\\Release\\DevMenuCommandSystem.nsp");
        }

        private bool ExecuteDevMenuCommandCommon(string args, string ncaPath)
        {
            Console.WriteLine("ExecuteDevMenuCommandCommon start.");

            using (var process = new Process())
            {
                var testPath = new TestUtility.TestPath(this.TestContext);
                var standardOutput = new StringBuilder();
                var standardError = new StringBuilder();

                process.StartInfo.FileName = testPath.GetSigloRoot() + "\\Tools\\CommandLineTools\\RunOnTarget.exe";
                process.StartInfo.Arguments = " -t " + targetName +
                                              " --pattern-failure-exit \\[FAILURE\\] " +
                                              " --failure-timeout 30 " +
                                              " -v " +
                                              ncaPath +
                                              " -- " +
                                              args;
                process.StartInfo.CreateNoWindow = true;
                process.StartInfo.UseShellExecute = false;
                process.StartInfo.RedirectStandardOutput = true;
                process.StartInfo.RedirectStandardError = true;
                process.StartInfo.StandardOutputEncoding = System.Text.Encoding.UTF8;
                process.OutputDataReceived += (object sender, DataReceivedEventArgs e) =>
                {
                    standardOutput.AppendLine(e.Data);
                };
                process.ErrorDataReceived += (object sender, DataReceivedEventArgs e) =>
                {
                    standardError.AppendLine(e.Data);
                };

                Console.WriteLine("process start.");
                Console.WriteLine(String.Format("FileName={0}, Arguments={1}", process.StartInfo.FileName, process.StartInfo.Arguments));
                process.Start();
                process.BeginOutputReadLine();
                process.BeginErrorReadLine();
                Console.WriteLine("process wait for exit.");
                process.WaitForExit();

                Console.WriteLine(String.Format("Standard Output: {0}", standardOutput.ToString()));
                Console.WriteLine(String.Format("Standard Error: {0}", standardError.ToString()));

                return process.ExitCode == 0;
            }
        }

        private bool ExecuteRunOnTarget(string option, string ncaPath)
        {
            Console.WriteLine("RunOnTargetCommon start.");

            using (var process = new Process())
            {
                var testPath = new TestUtility.TestPath(this.TestContext);
                var standardOutput = new StringBuilder();
                var standardError = new StringBuilder();

                process.StartInfo.FileName = testPath.GetSigloRoot() + "\\Tools\\CommandLineTools\\RunOnTarget.exe";
                process.StartInfo.Arguments = " -t " + targetName +
                                              " --failure-timeout 60 " +
                                              " -v " +
                                              option +
                                              " " +
                                              ncaPath;
                process.StartInfo.CreateNoWindow = true;
                process.StartInfo.UseShellExecute = false;
                process.StartInfo.RedirectStandardOutput = true;
                process.StartInfo.RedirectStandardError = true;
                process.StartInfo.StandardOutputEncoding = System.Text.Encoding.UTF8;
                process.OutputDataReceived += (object sender, DataReceivedEventArgs e) =>
                {
                    standardOutput.AppendLine(e.Data);
                };
                process.ErrorDataReceived += (object sender, DataReceivedEventArgs e) =>
                {
                    standardError.AppendLine(e.Data);
                };

                Console.WriteLine("process start.");
                Console.WriteLine(String.Format("FileName={0}, Arguments={1}", process.StartInfo.FileName, process.StartInfo.Arguments));
                process.Start();
                process.BeginOutputReadLine();
                process.BeginErrorReadLine();
                Console.WriteLine("process wait for exit.");
                process.WaitForExit();

                Console.WriteLine(String.Format("Standard Output: {0}", standardOutput.ToString()));
                Console.WriteLine(String.Format("Standard Error: {0}", standardError.ToString()));

                return process.ExitCode == 0;
            }
        }

        [TestMethod]
        public void TestAppletSequence()
        {
            Console.WriteLine("TestAppletSequence start.");
            var testPath = new TestUtility.TestPath(this.TestContext);

            ExecuteDevMenuCommandSystem("systemprogram uninstall 0x0100000000001001");
            ExecuteDevMenuCommandSystem("systemprogram uninstall 0x0100000000001002");
            ExecuteDevMenuCommandSystem("systemprogram uninstall 0x0100000000001003");
            ExecuteDevMenuCommandSystem("systemprogram uninstall 0x0100000000001004");
            ExecuteDevMenuCommandSystem("systemprogram uninstall 0x0100000000001012");
            ExecuteDevMenuCommand("application uninstall 0x010000000000B1C0");

            Assert.IsTrue(ExecuteDevMenuCommandSystem("systemprogram install " + testPath.GetSigloRoot() + "\\Tests\\Outputs\\NX-NXFP2-a64\\Tests\\AeLibraryApplet1\\Develop\\AeLibraryApplet1.nsp"));
            Assert.IsTrue(ExecuteDevMenuCommandSystem("systemprogram install " + testPath.GetSigloRoot() + "\\Tests\\Outputs\\NX-NXFP2-a64\\Tests\\AeLibraryApplet2\\Develop\\AeLibraryApplet2.nsp"));
            Assert.IsTrue(ExecuteDevMenuCommandSystem("systemprogram install " + testPath.GetSigloRoot() + "\\Tests\\Outputs\\NX-NXFP2-a64\\Tests\\AeLibraryApplet3\\Develop\\AeLibraryApplet3.nsp"));
            Assert.IsTrue(ExecuteDevMenuCommandSystem("systemprogram install " + testPath.GetSigloRoot() + "\\Tests\\Outputs\\NX-NXFP2-a64\\Tests\\AeLibraryApplet4\\Develop\\AeLibraryApplet4.nsp"));
            Assert.IsTrue(ExecuteDevMenuCommandSystem("systemprogram install " + testPath.GetSigloRoot() + "\\Tests\\Outputs\\NX-NXFP2-a64\\Tests\\AeStarter\\Develop\\AeStarter.nsp"));
            Assert.IsTrue(ExecuteDevMenuCommand("application install " + testPath.GetSigloRoot() + "\\Tests\\Outputs\\NX-NXFP2-a64\\Tests\\OeApplication\\Develop\\OeApplication.nsp"));

            Assert.IsTrue(ExecuteRunOnTarget("--suppress-auto-kill --no-wait", testPath.GetSigloRoot() + "\\Tests\\Outputs\\NX-NXFP2-a64\\Tests\\AeOverlayApplet\\Develop\\AeOverlayApplet.nsp"));
            Assert.IsTrue(ExecuteRunOnTarget("--suppress-auto-kill --pattern-success-exit \"SA: === Pseudo Menu === \\(count: 0\\)\"", testPath.GetSigloRoot() + "\\Tests\\Outputs\\NX-NXFP2-a64\\Tests\\AeSystemApplet\\Develop\\AeSystemApplet.nsp"));

            Assert.IsTrue(ExecuteDevMenuCommandSystem("systemprogram uninstall 0x0100000000001001"));
            Assert.IsTrue(ExecuteDevMenuCommandSystem("systemprogram uninstall 0x0100000000001002"));
            Assert.IsTrue(ExecuteDevMenuCommandSystem("systemprogram uninstall 0x0100000000001003"));
            Assert.IsTrue(ExecuteDevMenuCommandSystem("systemprogram uninstall 0x0100000000001004"));
            Assert.IsTrue(ExecuteDevMenuCommandSystem("systemprogram uninstall 0x0100000000001012"));
            Assert.IsTrue(ExecuteDevMenuCommand("application uninstall 0x010000000000B1C0"));

            // 最後に DevMenu を再起動しておく
            Assert.IsTrue(ExecuteDevMenuCommandSystem("systemprogram launch 0x0100000000002064"));
        }
    }
}
