﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using _3dIntermediateFileMaterialGenerator;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.G3dTool.Entities;
using nw.g3d.iflib;
using nw.g3d.nw4f_3dif;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Reflection;

namespace _3dIntermediateFileMaterialGeneratorTest
{
    [TestClass]
    public class MainFunctionalityTest
    {
        [TestMethod]
        public void CreateAndEditMaterialTest()
        {
            G3dParallel.Job = 1;
            MaterialGenerator generator = new MaterialGenerator();
            List<string> currentMaterialNames = new List<string>();
            string filePath = $"{MethodBase.GetCurrentMethod().Name}.fmdb";

            if (System.IO.File.Exists(filePath))
            {
                System.IO.File.Delete(filePath);
            }

            // マテリアルの作成テスト
            {
                string[] materialNames = new string[] { "hoge", "fuga", "piyo" };
                currentMaterialNames.AddRange(materialNames);
                string args = $"create --material-names {string.Join(",", materialNames)} -o {filePath}";
                generator.Execute(
                    new Context(args.Split(' '))
                    {
                        XsdBasePath = _3dToolsTestUtility.IoUtility.GetXsdBasePath()
                    });
                var fileData = IfReadUtility.Read(filePath, _3dToolsTestUtility.IoUtility.GetXsdBasePath());
                var file = new IntermediateFile(fileData);
                var model = file.GetRootEntity<Model>();
                Assert.AreEqual(currentMaterialNames.Count, model.Materials.Count);
                foreach (string matName in currentMaterialNames)
                {
                    model.Materials.First(x => x.Name == matName);
                }
            }

            // マテリアルの追加テスト
            {
                string[] materialNames = new string[] { "hogehoge", "fugafuga", "piyopiyo" };
                currentMaterialNames.AddRange(materialNames);
                string args = $"add --material-names {string.Join(",", materialNames)} {filePath}";
                generator.Execute(
                    new Context(args.Split(' '))
                    {
                        XsdBasePath = _3dToolsTestUtility.IoUtility.GetXsdBasePath()
                    });
                var fileData = IfReadUtility.Read(filePath, _3dToolsTestUtility.IoUtility.GetXsdBasePath());
                var file = new IntermediateFile(fileData);
                var model = file.GetRootEntity<Model>();
                Assert.AreEqual(currentMaterialNames.Count, model.Materials.Count);
                foreach (string matName in currentMaterialNames)
                {
                    model.Materials.First(x => x.Name == matName);
                }
            }

            // マテリアルの削除テスト
            {
                string[] materialNames = new string[] { "hoge", "fuga", "piyo" };
                foreach (string materialName in materialNames)
                {
                    currentMaterialNames.Remove(materialName);
                }
                string args = $"remove --material-names {string.Join(",", materialNames)} {filePath}";
                generator.Execute(
                    new Context(args.Split(' '))
                    {
                        XsdBasePath = _3dToolsTestUtility.IoUtility.GetXsdBasePath()
                    });
                var fileData = IfReadUtility.Read(filePath, _3dToolsTestUtility.IoUtility.GetXsdBasePath());
                var file = new IntermediateFile(fileData);
                var model = file.GetRootEntity<Model>();
                Assert.AreEqual(currentMaterialNames.Count, model.Materials.Count);
                foreach (string matName in currentMaterialNames)
                {
                    model.Materials.First(x => x.Name == matName);
                }
            }

            // マテリアルのリネーム
            {
                string oldName = "piyopiyo";
                string newName = "piyo";
                currentMaterialNames.Remove(oldName);
                currentMaterialNames.Add(newName);
                string args = $"rename --old-material-name {oldName} --new-material-name {newName} {filePath}";
                generator.Execute(
                    new Context(args.Split(' '))
                    {
                        XsdBasePath = _3dToolsTestUtility.IoUtility.GetXsdBasePath()
                    });
                var fileData = IfReadUtility.Read(filePath, _3dToolsTestUtility.IoUtility.GetXsdBasePath());
                var file = new IntermediateFile(fileData);
                var model = file.GetRootEntity<Model>();
                Assert.AreEqual(currentMaterialNames.Count, model.Materials.Count);
                foreach (string matName in currentMaterialNames)
                {
                    model.Materials.First(x => x.Name == matName);
                }
            }
        }
    }
}
