﻿using System;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using nw.g3d.nw4f_3dif;
using System.Diagnostics;
using System.Collections.Generic;
using nw.g3d.iflib;

namespace _3dIntermediateFileLibraryTest
{
    [TestClass]
    public class AssignTest
    {
        [TestMethod]
        public void ApplyParentMaterialTest()
        {
            string fmdPath = "Resources/ApplyParentMaterialTest.fmdb";
            string shaderFolder = "Resources";

            nw4f_3difType appliedFile = IfApplyBaseMaterialUtility.ApplyBaseMaterial(
                fmdPath,
                "ApplyParentMaterialTestOutput.fmdb",
                shaderFolder,
                true);

            modelType model = appliedFile.Item as modelType;
            materialType skinMaterial = model.material_array.material.FirstOrDefault(x => x.name == "m_skin");
            string ownSamplerName = "sampler0";

            // サンプラー構成の制限によって子マテリアル独自のサンプラーが削除されていることをチェック
            Assert.AreEqual(4, skinMaterial.sampler_array.sampler.Length);
            Assert.IsFalse(skinMaterial.sampler_array.sampler.Any(x => x.name == ownSamplerName));

            // 削除されたサンプラーの割り当てが残っていないかチェック
            foreach (var assign in skinMaterial.shader_assign.sampler_assign_array.sampler_assign)
            {
                Assert.AreNotEqual(ownSamplerName, assign.sampler_name);
            }
        }

        [TestMethod]
        public void AssignShaderTest()
        {
            modelType model = new modelType()
            {
                material_array = new material_arrayType()
                {
                    Items = new materialType[]
                    {
                        new materialType()
                        {
                            name = "matA"
                        },
                        new materialType()
                        {
                            name = "matB"
                        },
                        new materialType()
                        {
                            name = "matB_2"
                        },
                    },
                }
            };

            materialType matA = model.material_array.Items[0];
            materialType matB = model.material_array.Items[1];
            materialType matB2 = model.material_array.Items[2];

            string shaderArchiveName = "shaderX";
            shading_modelType shadingModel = new shading_modelType()
            {
                name = "shadingModelX"
            };

            // 正常系のテスト、一方のマテリアルだけアサイン
            {
                matA.shader_assign = null;
                matB.shader_assign = null;
                matB2.shader_assign = null;

                IfShaderAssignUtility.AssignShaderAssign(
                    model, new string[] { "matA" }, shaderArchiveName, shadingModel, false, false);

                Assert.AreEqual(shaderArchiveName, matA.shader_assign.shader_archive);
                Assert.AreEqual(shadingModel.name, matA.shader_assign.shading_model);
                Assert.AreEqual(null, matB.shader_assign);
                Assert.AreEqual(null, matB2.shader_assign);
            }

            // 正常系のテスト、ワイルドカード指定でアサイン
            {
                matA.shader_assign = null;
                matB.shader_assign = null;
                matB2.shader_assign = null;

                IfShaderAssignUtility.AssignShaderAssign(
                    model, new string[] { "matB*" }, shaderArchiveName, shadingModel, false, false);

                Assert.AreEqual(null, matA.shader_assign);
                Assert.AreEqual(shaderArchiveName, matB.shader_assign.shader_archive);
                Assert.AreEqual(shadingModel.name, matB.shader_assign.shading_model);
                Assert.AreEqual(shaderArchiveName, matB2.shader_assign.shader_archive);
                Assert.AreEqual(shadingModel.name, matB2.shader_assign.shading_model);
            }

            // 指定したマテリアルが存在しない場合は何もしないことを確認
            {
                matA.shader_assign = null;
                matB.shader_assign = null;
                matB2.shader_assign = null;

                IfShaderAssignUtility.AssignShaderAssign(
                    model, new string[] { "matC" }, shaderArchiveName, shadingModel, false, false);

                Assert.AreEqual(null, matA.shader_assign);
                Assert.AreEqual(null, matB.shader_assign);
                Assert.AreEqual(null, matB2.shader_assign);

                // ワイルドーカード指定で存在しないケース
                IfShaderAssignUtility.AssignShaderAssign(
                    model, new string[] { "mat*C" }, shaderArchiveName, shadingModel, false, false);

                Assert.AreEqual(null, matA.shader_assign);
                Assert.AreEqual(null, matB.shader_assign);
                Assert.AreEqual(null, matB2.shader_assign);
            }
        }
    }
}
