﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.G3dTool.Entities;
using nw.g3d.nw4f_3dif;
using System.Linq;

namespace G3dLibraryTest
{
    [TestClass]
    public class SceneAnimTest
    {
        [TestMethod]
        public void SceneAnimStreamReferenceTest()
        {
            var sourceFile = new IntermediateFile(IntermediateFileKind.SceneAnim);
            var sceneAnim = sourceFile.GetRootEntity<SceneAnim>();
            sceneAnim.Streams.Add(new StreamFloat());
            sceneAnim.Streams.Add(new StreamFloat());
            sceneAnim.Streams.Add(new StreamFloat());
            sceneAnim.Streams.Add(new StreamFloat());

            // カメラアニメーション
            {
                var testTargetKey = camera_anim_target_targetType.position_x;
                int streamIndex = 1;
                var cameraAnim = new CameraAnim();
                sceneAnim.CameraAnims.Add(cameraAnim);
                Assert.IsNotNull(cameraAnim.Parent);

                var target = cameraAnim.CameraAnimTargets[testTargetKey];
                Assert.IsNotNull(target.Parent);

                var curve = new LinearCurve();
                target.Curve = curve;
                Assert.IsNotNull(curve.Parent);

                curve.Stream = sceneAnim.Streams[streamIndex];

                cameraAnim.RotateMode = camera_anim_rotate_modeType.euler_zxy;
                cameraAnim.ProjectionMode = camera_anim_projection_modeType.persp;

                var writeData = sourceFile.CreateSerializableData();
                Assert.AreEqual(1, (writeData.Item as scene_animType).camera_anim_array.Items[0].camera_anim_target.Length);
                Assert.AreEqual(streamIndex, (writeData.Item as scene_animType).camera_anim_array.Items[0].camera_anim_target.First(x => x.target == testTargetKey).Curve.stream_index);

                // 再度データモデル構築後にストリームの参照が作られるかをチェック
                var file = new IntermediateFile(writeData);
                Assert.IsNotNull(file.GetRootEntity<SceneAnim>().CameraAnims[0].CameraAnimTargets[testTargetKey].Curve.Stream);
            }

            // ライトアニメーション
            {
                var testTargetKey = light_anim_target_targetType.position_x;
                int streamIndex = 2;
                var anim = new LightAnim();
                sceneAnim.LightAnims.Add(anim);
                Assert.IsNotNull(anim.Parent);

                var target = anim.LightAnimTargets[testTargetKey];
                Assert.IsNotNull(target.Parent);

                var curve = new LinearCurve();
                target.Curve = curve;
                Assert.IsNotNull(curve.Parent);

                StreamFloat dummyStream = new StreamFloat();
                sceneAnim.Streams.Add(dummyStream);

                curve.Stream = sceneAnim.Streams[streamIndex];

                var writeData = sourceFile.CreateSerializableData();
                Assert.AreEqual(1, (writeData.Item as scene_animType).light_anim_array.Items[0].light_anim_target.Length);
                Assert.AreEqual(streamIndex, (writeData.Item as scene_animType).light_anim_array.Items[0].light_anim_target.First(x => x.target == testTargetKey).Curve.stream_index);

                // 再度データモデル構築後にストリームの参照が作られるかをチェック
                var file = new IntermediateFile(writeData);
                Assert.IsNotNull(file.GetRootEntity<SceneAnim>().LightAnims[0].LightAnimTargets[testTargetKey].Curve.Stream);
            }

            // フォグアニメーション
            {
                var testTargetKey = fog_anim_target_targetType.dist_attn_start;
                int streamIndex = 3;
                var anim = new FogAnim();
                sceneAnim.FogAnims.Add(anim);
                Assert.IsNotNull(anim.Parent);

                var target = anim.FogAnimTargets[testTargetKey];
                Assert.IsNotNull(target.Parent);

                var curve = new LinearCurve();
                target.Curve = curve;
                Assert.IsNotNull(curve.Parent);

                StreamFloat dummyStream = new StreamFloat();
                sceneAnim.Streams.Add(dummyStream);

                curve.Stream = sceneAnim.Streams[streamIndex];

                var writeData = sourceFile.CreateSerializableData();
                Assert.AreEqual(1, (writeData.Item as scene_animType).fog_anim_array.Items[0].fog_anim_target.Length);
                Assert.AreEqual(streamIndex, (writeData.Item as scene_animType).fog_anim_array.Items[0].fog_anim_target.First(x => x.target == testTargetKey).Curve.stream_index);

                // 再度データモデル構築後にストリームの参照が作られるかをチェック
                var file = new IntermediateFile(writeData);
                Assert.IsNotNull(file.GetRootEntity<SceneAnim>().FogAnims[0].FogAnimTargets[testTargetKey].Curve.Stream);
            }
        }
    }
}
