﻿#include "edittest_common.glsl"
#include "edittest_material.glsl"

#ifdef NW_VERTEX_SHADER

void main()
{
    const mat4 viewFix = mat4(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, -50, 1);
    const mat4 projFix = mat4(2.253270, 0, 0, 0, 0, 2.414210, 0, 0, 0, 0, -1, -1, 0, 0, -1, 0);
    
    v_texcoord = i_uv0;

    vec4 tempPos  = vec4(i_position0, 1);
    vec4 tempNorm = vec4(i_normal0, 0);
    vec4 outPos = vec4(0, 0, 0, 1);
    vec3 outNorm = vec3(0, 0, 0);

    if (vertex_skinning_count == 0)
    {
        outPos.x = dot(world[0], tempPos);
        outPos.y = dot(world[1], tempPos);
        outPos.z = dot(world[2], tempPos);

        outNorm.x = dot(world[0], tempNorm);
        outNorm.y = dot(world[1], tempNorm);
        outNorm.z = dot(world[2], tempNorm);
    }
    else if (vertex_skinning_count == 1)
    {
        int index = i_index0[0];

        outPos.x = dot(bone[index * 3 + 0], tempPos);
        outPos.y = dot(bone[index * 3 + 1], tempPos);
        outPos.z = dot(bone[index * 3 + 2], tempPos);

        outNorm.x = dot(bone[index * 3 + 0], tempNorm);
        outNorm.y = dot(bone[index * 3 + 1], tempNorm);
        outNorm.z = dot(bone[index * 3 + 2], tempNorm);
    }
    else
    {
        for (int i = 0; i < 4; ++i)
        {
            // HACK: ドライババージョンによっては
            //       for 文に int の Uniform が使えないための回避策です。
            if ( i >= vertex_skinning_count )
            {
                continue;
            }
            
            int index = i_index0[i];
            float weight = i_weight0[i];

            outPos.x += weight * dot(bone[index * 3 + 0], tempPos);
            outPos.y += weight * dot(bone[index * 3 + 1], tempPos);
            outPos.z += weight * dot(bone[index * 3 + 2], tempPos);

            outNorm.x += weight * dot(bone[index * 3 + 0], tempNorm);
            outNorm.y += weight * dot(bone[index * 3 + 1], tempNorm);
            outNorm.z += weight * dot(bone[index * 3 + 2], tempNorm);

            //outColor[i] += weight;
        }
    }

    tempPos = outPos;
    tempNorm.xyz = normalize(outNorm);

    vec4 viewPos = vec4(0, 0, 0, 1);
    vec3 viewNorm = vec3(0, 0, 0);
#if 1
    viewPos.x = dot(view[0], tempPos);
    viewPos.y = dot(view[1], tempPos);
    viewPos.z = dot(view[2], tempPos);

    viewNorm.x = dot(view[0], tempNorm);
    viewNorm.y = dot(view[1], tempNorm);
    viewNorm.z = dot(view[2], tempNorm);

    outPos.x = dot(proj[0], viewPos);
    outPos.y = dot(proj[1], viewPos);
    outPos.z = dot(proj[2], viewPos);
    outPos.w = dot(proj[3], viewPos);
#else
    viewPos = viewFix * tempPos;
    viewNorm = viewFix * tempNorm;
    outPos = projFix * viewPos;
#endif

    // デバッグ用
    v_color = vec4(0.0f);

    v_viewPos = viewPos;
    v_normal = viewNorm;
    gl_Position = outPos;
}

#endif
