﻿#include "edittest_common.glsl"

#ifdef NW_FRAGMENT_SHADER

// @@ block_id="env" type="material"
// @@ uniform_id="hemiDir"     group="group_hemisphere_light" default="0 1 0 1"              min="-1" max="1" label="半球ライトの軸"
// @@ uniform_id="skyColor"    group="group_hemisphere_light" default="1 1 1 1" item="color" min="0"  max="1" label="半球ライトのスカイカラー"
// @@ uniform_id="groundColor" group="group_hemisphere_light" default="1 1 1 1" item="color" min="0"  max="1" label="半球ライトのグラウンドカラー"

// @@ uniform_id="lightDir"      group="group_directional_light" default="0 1 0 1"              min="-1" max="1" label="ライトの方向"
// @@ uniform_id="diffuseColor"  group="group_directional_light" default="1 1 1 1" item="color" min="0"  max="1" label="ライトのディフューズ項"
// @@ uniform_id="specularColor" group="group_directional_light" default="1 1 1 1" item="color" min="0"  max="1" label="ライトのスペキュラー項"

// @@ uniform_id="fogStart"       group="group_fog" default="0"       count="1"    min="0.1" max="10000" label="フォグの開始距離" 
// @@ uniform_id="fogStartEndInv" group="group_fog" default="10000"   count="1"    min="0.1" max="10000" label="フォグの末端距離" 
// @@ uniform_id="fogColor"       group="group_fog" default="1 1 1 1" item="color" min="0"   max="1"     label="フォグの色"

#endif

// @@ renderinfo="fog_kind"    group="group_fog" type="string" count="1" label="フォグの種類" default="linear"
// @@ renderinfo="clearColor"  group="group_basics" type="float"  order="1" count="3" label="クリアカラー" default="0 0 0"
// @@ renderinfo="weather_kind"    group="group_weather" type="string" count="1" label="天候" default=""

// @@ group="group_weather"

// @@ group="group_renderinfo1" label="描画情報テスト1" comment="描画情報のテスト用です。" order="10"
// @@ renderinfo="string_fsd" group="group_renderinfo1" type="string" count="2" label="文字列" choice="0:choice_1-10, 1:choice_11-99, 2:choice_100-255" default="0 1"
// @@ renderinfo="int_edit"   group="group_renderinfo1" type="int"    count="3" label="Int型" comment="接続時に「文字列」の一段目にしたがって choice が変わります。"
// @@ renderinfo="float_edit" group="group_renderinfo1" type="float"  count="3" label="Float型" comment="接続時に「文字列」の二段目にしたがって choice が変わります。"

// @@ group="group_renderinfo2" label="描画情報テスト2" comment="描画情報のテスト用です。（UI のみ）" order="10"
// @@ renderinfo="renderinfo_string"    group="group_renderinfo2" type="string" order="6" count="1" label="文字列（count変更不可）" choice="default_value, 1:文字列, 2:もじれつ" default="default_value" optional="false"
// @@ renderinfo="renderinfo_string_2"  group="group_renderinfo2" type="string" order="7" count="2" label="文字列[2]" choice="default_value, 1:文字列, 2:もじれつ" default="1 2" optional="true"
// @@ renderinfo="renderinfo_int"       group="group_renderinfo2" type="int"    order="2" count="1" label="int" choice="[-128, 128]" default="64"
// @@ renderinfo="renderinfo_int_4"     group="group_renderinfo2" type="int"    order="3" count="4" label="int[4]" choice="[100, 255]" default="100 123 200 255"
// @@ renderinfo="renderinfo_float"     group="group_renderinfo2" type="float"  order="4" count="1" label="float" choice="[-128, 128]" default="64"
// @@ renderinfo="renderinfo_float_4"   group="group_renderinfo2" type="float"  order="5" count="4" label="float[4]（count変更不可）" choice="[100, 255]" default="100 123 200 255" optional="false"
// @@ renderinfo="renderinfo_int_check" group="group_renderinfo2" type="int"    order="8" item="check" count="1" label="check" choice="[0, 10]" default="10"

#ifdef NW_VERTEX_SHADER

void main()
{
    vec4 tempPos  = vec4(i_position0, 1);
    vec4 tempNorm = vec4(i_normal0, 0);
    vec4 outPos = vec4(0, 0, 0, 1);
    vec3 outNorm = vec3(0, 0, 0);

    outPos.x = dot(world[0], tempPos);
    outPos.y = dot(world[1], tempPos);
    outPos.z = dot(world[2], tempPos);

    outNorm.x = dot(world[0], tempNorm);
    outNorm.y = dot(world[1], tempNorm);
    outNorm.z = dot(world[2], tempNorm);

    tempPos = outPos;
    tempNorm.xyz = normalize(outNorm);

    vec4 viewPos = vec4(0, 0, 0, 1);
    vec3 viewNorm = vec3(0, 0, 0);

    viewPos.x = dot(view[0], tempPos);
    viewPos.y = dot(view[1], tempPos);
    viewPos.z = dot(view[2], tempPos);

    viewNorm.x = dot(view[0], tempNorm);
    viewNorm.y = dot(view[1], tempNorm);
    viewNorm.z = dot(view[2], tempNorm);

    outPos.x = dot(proj[0], viewPos);
    outPos.y = dot(proj[1], viewPos);
    outPos.z = dot(proj[2], viewPos);
    outPos.w = dot(proj[3], viewPos);

    // デバッグ用
    v_color = vec4(0.0f);

    v_viewPos = viewPos;
    v_normal = viewNorm;
    gl_Position = outPos;
}

#endif

#ifdef NW_FRAGMENT_SHADER

void main()
{
    vec4 outColor = vec4(0.0, 0.0, 0.0, 0.0);

    {
        float costheta = dot(v_normal, -hemiDir.xyz);
        float a = costheta * 0.5 + 0.5;
        outColor.xyz = mix(skyColor.xyz, groundColor.xyz, a);
    }

    {
        float costheta = dot(v_normal, lightDir.xyz);
        outColor.xyz += vec3(1, 1, 1) * diffuseColor.xyz * costheta;
    }

    {
        float interpolation = clamp((-v_viewPos.z) * fogStartEndInv + fogStart, 0.0, 1.0);
        outColor.rgb += fogColor.rgb * interpolation;
    }
    gl_FragColor = outColor;
}

#endif
