﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include "SandboxUtility.h"
#include <nw/g3d/edit/g3d_EditDefs.h>
#include <nw/g3d/g3d_ModelObj.h>
#include <nw/g3d/g3d_res.h>

#include <vector>

namespace G3dSandbox {

#if NW_G3D_CONFIG_USE_HOSTIO
    class SandboxNwG3dEditor : public nw::g3d::edit::EditCallback
    {
    public:
        static void CreateInstance(
                std::vector<nw::g3d::ResFile*>* files,
                std::vector<nw::g3d::ResShaderArchive*>* shaderArchives,
                std::vector<AnimModelObj*>* models,
                std::vector<RenderModel*>* renderModels,
                float clearColorR, float clearColorG, float clearColorB);
        static void DeleteInstance();
        static SandboxNwG3dEditor* Instance();

        void CalcEditor();

        // GPU が直接リードするメモリを書き換えます。
        // CalcBlock などの GPU がメモリリードしないタイミングで呼び出してください。
        void CalcBlock();

        virtual void EditShadingModel(const nw::g3d::edit::EditShadingModelArg& arg);

        virtual nw::g3d::res::ResFile* LoadFile(const nw::g3d::edit::LoadFileArg& arg);

        virtual void UnloadFile(const nw::g3d::edit::UnloadFileArg& arg);

        virtual void UpdateShaderAssign(const nw::g3d::edit::UpdateShaderAssignArg& arg);

        virtual void UpdateMaterials(const nw::g3d::edit::UpdateMaterialsArg& arg);

        virtual void UpdateRenderInfo(const nw::g3d::edit::RenderInfoArg& arg);

        virtual void UpdateRenderState(nw::g3d::ModelObj* modelObj);

        virtual void SendRenderInfo(const nw::g3d::edit::SendRenderInfoArg& arg);

        virtual void UpdateBoneBind(const nw::g3d::edit::UpdateBoneBindArg& arg);

        virtual bool SendModelLayout(nw::g3d::edit::SendModelLayoutData* outputData, const nw::g3d::edit::SendModelLayoutArg& arg);

        virtual void UpdateModelLayout(const nw::g3d::edit::UpdateModelLayoutArg& arg);

        virtual void BindSceneAnim(const nw::g3d::edit::BindSceneAnimArg& arg);

        virtual void UnbindSceneAnim(const nw::g3d::edit::UnbindSceneAnimArg& arg);

        virtual void ApplySceneAnim(const nw::g3d::edit::ApplySceneAnimArg& arg);

        virtual void SelectTarget(const nw::g3d::edit::SelectTargetArg& arg);

        virtual void AttachModel(const nw::g3d::edit::AttachModelArg& arg);

        virtual void DetachModel(const nw::g3d::edit::DetachModelArg& arg);

        virtual void ExecuteModelUserScript(const nw::g3d::edit::ExecuteModelUserScriptArg& arg);

    private:
        SandboxNwG3dEditor() {}

        void PrintUpdateMaterialState(nw::g3d::edit::UpdateMaterialsArg::State state);

        void PrintRenderState(nw::g3d::ResRenderState* pResRenderState);

        std::vector<nw::g3d::ResFile*>* m_Files;
        std::vector<nw::g3d::ResShaderArchive*>* m_ShaderArchives;
        std::vector<AnimModelObj*>* m_Models;
        std::vector<RenderModel*>* m_RenderModels;
        float m_ClearColor[3];

        static SandboxNwG3dEditor* s_Instance;
    };
#endif
}
