﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "EditPollThreadManager.h"

#if NW_G3D_CONFIG_USE_HOSTIO

#include "SandboxUtility.h"

#include <nw/g3d/fnd/g3d_GfxManage.h>

using namespace G3dSandbox;

EditPollThreadManager::EditPollThreadManager(
    nw::g3d::edit::EditCallback* pCallback,
    nw::g3d::edit::IAllocator* pAllocator,
    nw::g3d::GfxContext* pCtx)
    : m_IsThreadLiving(false)
    , m_pGfxContext(pCtx)
{
    nw::g3d::edit::EditServer::CreateArg arg;
    arg.allocator = pAllocator;
#ifndef _WIN32 //VisualC++の仕様
    arg.codePage = 65001; // UTF8
#else
    arg.codePage = 932; //Shift-JIS
#endif
    arg.editCallback = pCallback;

    bool createResult = nw::g3d::edit::EditServer::CreateInstance( arg );
    NW_G3D_ASSERT(createResult);

    bool openConnectionResult = nw::g3d::edit::EditServer::Instance().Open();
    NW_G3D_ASSERT(openConnectionResult);
}

EditPollThreadManager::~EditPollThreadManager()
{
    DestroyThread();

    m_pGfxContext->Activate();

    {
        nw::g3d::edit::EditServer::Instance().Clear(true);
        nw::g3d::edit::EditServer::Instance().Close();
        nw::g3d::edit::EditServer::DeleteInstance();
    }
}

void EditPollThreadManager::CreateThead()
{
#ifdef _WIN32
    nn::Result  result = nn::os::CreateThread( &m_Thread, ThreadEntryFunction, this, m_ThreadStack, s_ThreadStackSize, nn::os::DefaultThreadPriority );
    NW_G3D_ASSERT(result.IsSuccess());
#else
    BOOL success = OSCreateThread(
        &m_Thread, ThreadEntryFunction, 0, this,
        m_ThreadStack + s_ThreadStackSize, s_ThreadStackSize, OS_PRIORITY_APP_DEFAULT,
        OS_THREAD_ATTR_DETACH | OS_THREAD_ATTR_AFFINITY_NONE);
    NW_G3D_ASSERT(success);
#endif
}

void EditPollThreadManager::StartThead()
{
    m_IsThreadLiving = true;
#ifdef _WIN32
    nn::os::StartThread( &m_Thread );
#else
    OSResumeThread(&m_Thread);
#endif
}

void EditPollThreadManager::DestroyThread()
{
    StopThread();
#ifdef _WIN32
    nn::os::WaitThread( &m_Thread );
    nn::os::DestroyThread( &m_Thread );
#else

#endif
}

void EditPollThreadManager::Lock()
{
    m_MutexLockManager.Lock();
}

void EditPollThreadManager::Unlock()
{
    m_MutexLockManager.Unlock();
}

void EditPollThreadManager::ThreadMain()
{
    nw::g3d::edit::EditServer::Instance().PollDataCommunication();
}

#ifdef _WIN32
void EditPollThreadManager::ThreadEntryFunction(void *ptrArg)
#else
int EditPollThreadManager::ThreadEntryFunction(int intArg, void* ptrArg)
#endif
{
    EditPollThreadManager* pManager = (EditPollThreadManager*)ptrArg;
    while(pManager->m_IsThreadLiving)
    {
        pManager->ThreadMain();
    }

#ifdef _WIN32
#else
    return 0;
#endif
}

#endif
