﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt.h>
#include <nn/nn_Common.h>

#if NN_BUILD_CONFIG_OS_WIN

// Windows.h 向けAPIと衝突しないかの確認

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif

#ifndef NOMINMAX
#define NOMINMAX
#endif

#include <nn/nn_Windows.h>

#endif // NN_BUILD_CONFIG_OS_WIN

#include <nn/nifm.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/time.h>
#include <nn/util/util_ScopeExit.h>

/**
 * @brief   渡された命令を GoogleTest フレームワークの ASSERT で検証します。
 *
 * @param[in]   statement   命令
 *
 * @details
 *  statement の実行中、 GoogleTest フレームワークの ASSERT が失敗した場合に
 *  ログを出力してテストを中断します。
 *  そのとき本マクロ以降のプログラムは実行されません。
 */
#define NNT_TIME_ASSERT_NO_FAILURE(statement) \
    do                                                      \
    {                                                       \
        (statement);                                        \
        if(::testing::Test::HasFatalFailure())              \
        {                                                   \
            GTEST_FATAL_FAILURE_("  Error: " #statement);   \
        }                                                   \
    } while(NN_STATIC_CONDITION(false))

/**
 * @brief   渡された命令を GoogleTest フレームワークの EXPECT で検証します。
 *
 * @param[in]   statement   命令
 *
 * @details
 *  statement の実行中、 GoogleTest フレームワークの ASSERT が失敗した場合に
 *  ログを出力ます。
 *  そのときテストの実行は中断されず、本マクロ以降のプログラムも実行されます。
 */
#define NNT_TIME_EXPECT_NO_FAILURE(statement) \
    do                                                          \
    {                                                           \
        (statement);                                            \
        if(::testing::Test::HasFatalFailure())                  \
        {                                                       \
            GTEST_NONFATAL_FAILURE_("  Error: " #statement);    \
        }                                                       \
    } while(NN_STATIC_CONDITION(false))

