﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/fs.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/nn_Assert.h>
#include <nn/os/os_Mutex.h>

#include "testHtc_FsLibraryAllocator.h"

using namespace nn::lmem;

namespace nnt { namespace htc { namespace detail {

namespace {
HeapHandle g_FsLibraryHeapHandle;
const size_t FsLibraryHeapSize = 16 * 1024;
char       g_FsLibraryHeap[FsLibraryHeapSize];
nn::os::Mutex mutex(true);

void InitializeFsLibraryHeap()
{
    std::lock_guard<nn::os::Mutex> scopedLock(mutex);
    g_FsLibraryHeapHandle = CreateExpHeap(g_FsLibraryHeap, FsLibraryHeapSize, CreationOption_NoOption);
    NN_ASSERT_NOT_NULL(g_FsLibraryHeapHandle);
}

void* FsLibraryHeapAllocate(size_t size)
{
    std::lock_guard<nn::os::Mutex> scopedLock(mutex);
    return AllocateFromExpHeap(g_FsLibraryHeapHandle, size);
}

void FsLibraryHeapDeallocate(void* p, size_t size)
{
    std::lock_guard<nn::os::Mutex> scopedLock(mutex);
    NN_UNUSED(size);
    return FreeToExpHeap(g_FsLibraryHeapHandle, p);
}

} // namespace

void InitializeFsLibraryAllocator()
{
    InitializeFsLibraryHeap();
    nn::fs::SetAllocator(FsLibraryHeapAllocate, FsLibraryHeapDeallocate);
}

}}}
