import time
import thread
import socket
import sys
import struct

shellhost="192.168.0.10"
shellport=8020
shellsock=-1
shellwaiting=True
shellsuccess=False
headersize=3
'''
packet header:
	bytes[0:1] - unsigned size of the packet, excluding the header
	bytes[2]   - packet type
	bytes[3: 3+size] - packet message
'''
def listen(name, unused):
	global shellwaiting
	global shellsuccess
	global end_time
	global headersize
	packet = bytearray(1024)

	while True:
		buffer = memoryview(packet)
		index = 0
		toReceive=headersize
		
		#read the header
		while toReceive:
			received = shellsock.recv_into(buffer, headersize)
			buffer = buffer[received:]
			toReceive -= received
	
		#read the rest of the packet
		bytes = bytearray()
		bytes.extend(packet)
		packetSize = struct.unpack("!H", bytes[0:2])[0]
		
		toReceive = packetSize
		while toReceive:
			buffer = shellsock.recv_into(buffer, packetSize)
			bufer = packet[buffer:]
			toReceive -= buffer

		bytes = bytearray()
		bytes.extend(packet)		
		
		#command failed
		if(bytes[2] == 0):
			shellwaiting=False
			shellsuccess=False
		#command passed
		if(bytes[2] == 1):
			shellwaiting=False
			shellsuccess=True
		#command still running
		if(bytes[2] == 2):
			end_time = time.clock() + 1.0
			pass
		string = bytes[3: 3+packetSize].decode("ascii")
		if len(string[0: string.find('\0')]) > 1:
			print string[0: string.find('\0')]
		
class TaskCreateArgs:
	priority=None
	core=None
	suspended=None
	verbosity=None
	timestamps=None
	console_write=None
	
	def to_string(self):
		result = ""
		if self.priority is not None:
			result = result + " PRIORITY=" + str(self.priority)
		if self.core is not None:
			result = result + " CORE=" + str(self.core)
		if self.verbosity is not None:
			result = result + " LOG_VERBOSITY=" + str(self.verbosity)
		if self.timestamps is not None:
			if self.timestamps:
				result = result + " LOG_TIMESTAMPS=1"
			else:
				result = result + " LOG_TIMESTAMPS=0"
		if self.console_write is not None:
			if self.console_write:
				result = result + " LOG_TO_CONSOLE=1"
			else:
				result = result + " LOG_TO_CONSOLE=0"
		if self.suspended is not None:
			if self.suspended:
				result = result + " SUSPENDED=1"
			else:
				result = result + " SUSPENDED=0"
		return result
	
def connect(host, port):
	global shellhost
	global shellport
	global shellsock
	shellhost = host
	shellport = port
	shellsock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
	print "Created socket " + str(shellsock)
	shellsock.connect((host, port))
	thread.start_new_thread(listen, ("Listener",None))

def send_packet(message):
	global shellwaiting
	global end_time;
	shellwaiting=True
	shellsock.sendto(message, (shellhost, shellport))
	
	end_time = time.clock() + 10.0
	while shellwaiting and time.clock() < end_time:
		pass
		
	if time.clock() >= end_time:
		print "timeout waiting for response to\n" + message + "\nassuming command passed"
	return shellsuccess

def disconnect(self):
	shellsock.close()
	
def start_script(filename):
	message="run_script " + filename
	return send_packet(message)
	
def stop_script():
	print (shellsock)
	message="stop_script"
	return send_packet(message)
	
def wait(seconds):
	message="do_command WAIT " + str(seconds)
	return send_packet(message)
	
def create_task(taskType, taskName, params, createArgs=None):
	if createArgs is not None:
		message="do_command CREATE" + " TASK=" + taskType + "  NAME=" + taskName + " PARAMS=" + params + " " + createArgs.to_string()
	else:
		message="do_command CREATE" + " TASK=" + taskType + "  NAME=" + taskName + " PARAMS=" + params
	return send_packet(message)

def kill_task(taskName):
	message="do_command KILL NAME="+taskName
	return send_packet(message)
	
def kill_all_tasks():
	message = "do_command KILLALLTASKS"
	return send_packet(message)
	
def suspend_task(taskName):
	message="do_command SUSPEND NAME="+taskName
	return send_packet(message)
	
def suspend_all_tasks():
	message = "do_command SUSPENDALLTASKS"
	return send_packet(message)
	
def resume_task(taskName):
	message="do_command RESUME NAME="+taskName
	return send_packet(message)
	
def resume_all_tasks():
	message = "do_command RESUMEALLTASKS"
	return send_packet(message)

def list_available_tasks(showParams=None):
	if(showParams is not None and showParams == False):
		message = "list_available_tasks 0"
		return send_packet(message)
	else:
		message = "list_available_tasks 1"
		return send_packet(message);
	
def exit_abuse():
	message = "exit_abuse"
	return send_packet(message)