﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "abuse_ui_Theme.h"
#include "abuse_ui_TaskListView.h"
#include "abuse_ui_Notifier.h"

namespace nnt {
namespace abuse {


// menu item "Task List". List of the active System Abuse tasks
TaskListView::TaskListView(ContentView& content) NN_NOEXCEPT
    : PageView(content, "Task List")
    , m_Label("System Abuse Tasks  ---  CPU Core")
{

    disable(glv::Property::DrawBack   |
            glv::Property::HitTest    |
            glv::Property::Animate);

    *this << m_Label.size(25).pos(glv::Place::TL, 30, 10);

    // register for update the System Abuse task list state change
    g_Notifier.attach(OnTaskListStateChange, Event_UpdateTaskListState, this);
}

TaskListView::~TaskListView() NN_NOEXCEPT
{
    // deregister for update the System Abuse task list state change
    g_Notifier.detach(OnTaskListStateChange, Event_UpdateTaskListState, this);
}


void TaskListView::UpdateLabel() NN_NOEXCEPT
{
    std::string strToOutput("System Abuse Tasks  ---  CPU Core\n\n");

    auto itr = m_TaskListItems.begin();
    while (itr != m_TaskListItems.end())
    {
        strToOutput += itr->task->GetTypeName().c_str();
        strToOutput += " --- " + std::to_string(itr->task->GetProcessor());
        strToOutput += "\n";
        itr++;
    }

    m_Label.setValue(strToOutput);
}


void TaskListView::OnTaskListStateChange(const glv::Notification& n) NN_NOEXCEPT
{
    TaskListView *self = n.receiver<TaskListView>();

    self->m_TaskListItems = *n.data<ListActiveTask>();
    self->UpdateLabel();
}

} // ~abuse
} // ~nnt
