﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <glv_notification.h>
#include <glv.h>
#include "Abuse.h"

namespace nnt {
namespace abuse {

enum Event
{
    Event_UpdateTaskListState,
    Event_ShowMenu,
    Event_HideMenu,

    Event_NumOfEvents
};


class GlobalNotifier : public glv::Notifier
{
public:
    GlobalNotifier() NN_NOEXCEPT;
    ~GlobalNotifier() NN_NOEXCEPT;

    void MonitorStart() NN_NOEXCEPT;
    void MonitorStop() NN_NOEXCEPT;

    void attach(Callback cb, Event event, void *rcvr) NN_NOEXCEPT
    {
        Notifier::attach(cb, static_cast<glv::Update::t>(event), rcvr);
    }

    void detach(Callback cb, Event event, void * rcvr) NN_NOEXCEPT
    {
        Notifier::detach(cb, static_cast<glv::Update::t>(event), rcvr);
    }

    void notify(Event event, void *data) NN_NOEXCEPT
    {
        Notifier::notify(static_cast<glv::Update::t>(event), data);
    }


private:
    // Monitor Thread
    nn::os::ThreadType                   m_Thread;
    NN_OS_ALIGNAS_THREAD_STACK uint8_t   m_ThreadStack[1024 * 4];
    bool                                 m_Done;

private:
    static void ThreadEntry(void *arg) NN_NOEXCEPT
    {
        reinterpret_cast<GlobalNotifier*>(arg)->Monitor();
    }

    void Monitor() NN_NOEXCEPT;

    // update the System Abuse task list
    void UpdateTaskListState() NN_NOEXCEPT;
};

extern GlobalNotifier g_Notifier;

} // ~abuse
} // ~nnt
