﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>

#include "abuse_ui_Notifier.h"


namespace nnt {
namespace abuse {

GlobalNotifier g_Notifier;


// notifies the UI of system events
GlobalNotifier::GlobalNotifier() NN_NOEXCEPT
{
    // N.B. Notifier class won't allocate enough slots for mHandlers, so we
    // must do it here. (Event_NumOfEvents > glv::Update::NumTypes)
    mHandlers = new std::vector<Handler>[Event_NumOfEvents];
}

GlobalNotifier::~GlobalNotifier() NN_NOEXCEPT
{
}

void GlobalNotifier::MonitorStart() NN_NOEXCEPT
{
    m_Done = false;

    nn::os::CreateThread(&m_Thread,
                         ThreadEntry,
                         this,
                         m_ThreadStack,
                         sizeof(m_ThreadStack),
                         nn::os::DefaultThreadPriority);
    nn::os::StartThread(&m_Thread);
}

void GlobalNotifier::MonitorStop() NN_NOEXCEPT
{
    m_Done = true;

    nn::os::WaitThread(&m_Thread);
    nn::os::DestroyThread(&m_Thread);
}

void GlobalNotifier::Monitor() NN_NOEXCEPT
{
    nn::os::SystemEventType clearEvent;

    nn::os::CreateSystemEvent(&clearEvent, nn::os::EventClearMode_AutoClear, false);

    while (!m_Done)
    {
        // wait for system event to occur
        bool fSysEvent =  nn::os::TimedWaitSystemEvent(&clearEvent, nn::TimeSpan::FromMilliSeconds(10000));

        if (fSysEvent)
        {
        }
        else
        {
            // timeout
            UpdateTaskListState();
        }
    }

    nn::os::DestroySystemEvent(&clearEvent);
}


void GlobalNotifier::UpdateTaskListState() NN_NOEXCEPT
{
    ListActiveTask* activeTask = Abuse::GetActiveTasksList();

    notify(Event_UpdateTaskListState, activeTask);
}

} // ~abuse
} // ~nnt
