﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <Tasks/UnitTestTask.h>
#include <nn/fs.h>
// #include <nn/nn_Log.h>
// #include <nnt/nntest.h>
#include <nn/ns/ns_DevelopApi.h>
#include <nn/ns/srv/ns_Shell.h>
#include <nn/lr/lr_LocationResolver.h>
#include <nn/lr/lr_Service.h>
#include <nn/os/os_Thread.h>
#include <nn/pm/pm_ShellApi.h>
#include <nn/util/util_FormatString.h>
#include <Platform.h>


namespace nnt
{
    namespace abuse
    {
        bool                        g_LocationResolverInitialized = false;
        nn::lr::LocationResolver    g_LocationResolver;
        // static const char HOSTNAME[] = "@Host:/";


        UnitTestTask::UnitTestTask(const String& typeName, const String& instanceName)
            : BaseTask(typeName, instanceName)
        {
        }

        UnitTestTask::~UnitTestTask()
        {
        }

        InitStatus UnitTestTask::Initialize(const String& params)
        {
            LogInfo("%s\n", params.c_str());
            LogInfo("UnitTest Initialize\n");

            // save off the stack and params value
            UnitTestThreadInfo threadInfo;
            nn::util::SNPrintf(threadInfo.arg.fileName, MAX_PATH_LENGTH, "%s", params.c_str());
            m_listThreadInfo.push_back(threadInfo);

            return INIT_OK;
        }

        StartStatus UnitTestTask::Start()
        {
            LogInfo("UnitTest Start\n");
            return START_OK;
        }

        RunStatus UnitTestTask::Run()
        {
            bool bResult;

            for (std::list<UnitTestThreadInfo, PlatformAllocator<UnitTestThreadInfo>>::iterator it = m_listThreadInfo.begin(); it != m_listThreadInfo.end(); it++)
            {
                UnitTestThreadInfo threadInfo = *it;
                threadInfo.stack = Platform::AllocateAligned(STACK_SIZE, nn::os::ThreadStackAlignment);

                bResult = nn::os::CreateThread(
                            &threadInfo.thread,
                            ThreadFunc,
                            (void *) &threadInfo.arg.fileName,
                            threadInfo.stack,
                            STACK_SIZE,
                            nn::os::DefaultThreadPriority).IsSuccess();

                if (bResult)
                {
                    nn::os::StartThread(&threadInfo.thread);
                    nn::os::WaitThread(&threadInfo.thread);
                    DestroyThread(&threadInfo.thread);
                }

                Platform::Free(threadInfo.stack, STACK_SIZE);
            }

            LogVerbose("UnitTest run\n");
            return RUN_OK;
        }

        StopStatus UnitTestTask::Stop()
        {
            LogInfo("UnitTest Stop\n");
            return STOP_OK;
        }

        ShutdownStatus UnitTestTask::Shutdown()
        {
            LogInfo("UnitTest Shutdown\n");

            return SHUTDOWN_OK;
        }

        void UnitTestTask::ThreadFunc(void* threadArg)
        {
/*
// TODO:  launch test in the same process as System Abuse, not a separate process

            UnitTestThreadArg* arg = (UnitTestThreadArg*)threadArg;
            nn::Result result;
            nn::os::ProcessId processId;
            uint64_t programIdValue = 0xF000000200000101ull;
            nn::ncm::ProgramId programId = { programIdValue };
            nn::ncm::ProgramLocation location;
            nn::lr::Path path;

            if( !g_LocationResolverInitialized )
            {
                #ifndef WIN32
                    // initialize for nn::ns::srv::LaunchProgram
                    nn::pm::InitializeForShell();
                #endif

                // initialize g_LocationResolver
                nn::lr::Initialize();
                NN_ABORT_UNLESS(nn::lr::OpenLocationResolver(&g_LocationResolver, nn::ncm::StorageId::Host).IsSuccess());
                g_LocationResolverInitialized = true;
            }


            std::memcpy(path.string, HOSTNAME, std::strlen(HOSTNAME));
            std::memcpy(path.string + std::strlen(HOSTNAME), arg->fileName, std::strlen(arg->fileName));
            g_LocationResolver.RedirectProgramPath(programId, path);


            // run all Google unit tests
            #ifndef WIN32
                location = nn::ncm::MakeProgramLocation(nn::ncm::StorageId::Host, programId);
                result = nn::ns::srv::LaunchProgram(&processId, location, nn::ns::LaunchProgramFlags_None);
                if (result.IsFailure())
                {
                    return;
                }
            #endif
*/
        }
    }
}
