﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "Commands/CommandSuspendTask.h"
#include <Abuse.h>

namespace nnt
{
    namespace abuse
    {
            bool CommandSuspendAllTasks::Execute(unsigned& nextCommand)
            {

                ++nextCommand;
                Abuse::SuspendAllTasks();
                return true;
            }

            ParseResult CommandSuspendAllTasks::ParseArgs(const ArgVector& args, CommandVector& commands)
            {
                (void)commands;
                if(args.size() == 0)
                    return ParseResult::PARSE_SUCCESS;
                else
                    return ParseResult::PARSE_INVALID_ARG;
            }

            ParseResult CommandSuspendTask::ParseArgs(const ArgVector& args, CommandVector& commands)
            {
                    instanceName = args[0].argValue;
                    bool parsed = ParseIteratorValues(args[0].argValue, commands, iteratorValues, formattedName);

                    if(!parsed)
                        return ParseResult::PARSE_INVALID_ARG;
                    else
                        return ParseResult::PARSE_SUCCESS;
            }

            bool CommandSuspendTask::Execute(unsigned& nextCommand)
            {
                ++nextCommand;

                String name;
                BuildFormattedName(formattedName, iteratorValues, name);
                return  Abuse::SuspendTask(name);
            }
    }
}
