﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <Commands/CommandCreateTask.h>
#include <Commands/BaseCommand.h>
#include <Commands/CommandLoop.h>
#include <Tasks/BaseTask.h>
#include <Abuse.h>
#include <FileUtility.h>
namespace nnt
{
    namespace abuse
    {
        CommandCreateTask::~CommandCreateTask()
        {
        }

        ParseResult CommandCreateTask::ParseArgs(const ArgVector& args, CommandVector& commandList)
        {
            NN_UNUSED(commandList);
            instanceName = "";

            bool invalidArg = false;
            for(unsigned i = 0; i < args.size(); ++i)
            {
                if(args[i].argName == "TASK")
                    createArgs.typeName = args[i].argValue;
                else if(args[i].argName == "CORE")
                {
                    int core;
                    bool parsed = ParseInt(&core, args[i].argValue);
                    if(!parsed || core >= nnt::abuse::NUM_CORES)
                        invalidArg = true;
                    else
                        createArgs.processor = core;
                }
                else if(args[i].argName == "LOAD")
                {
                    bool parsed = ParseInt(&createArgs.load, args[i].argValue);
                    if(!parsed)
                        invalidArg = true;
                }
                else if(args[i].argName == "NAME")
                {
                    instanceName = args[i].argValue;
                    bool parsed = ParseIteratorValues(args[i].argValue, commandList, iteratorValues, formattedName);
                    if(!parsed)
                        invalidArg = true;
                }
                else if(args[i].argName == "PARAMS")
                {
                    createArgs.params = args[i].argValue;
                }
                else if(args[i].argName == "PRIORITY")
                {
                    bool parsed = ParseInt(&createArgs.priority, args[i].argValue);
                    if(!parsed)
                        invalidArg = true;
                }
                else if(args[i].argName=="LOG_VERBOSITY")
                {
                    unsigned verbosity;
                    bool parsed = ParseUnsigned(&verbosity, args[i].argValue);
                    if(!parsed || verbosity > LogVerbosity::NumVerbosityLevels)
                        invalidArg = true;
                    else
                    {
                        createArgs.verbosity = (LogVerbosity)verbosity;
                    }
                }
                else if(args[i].argName=="LOG_TIMESTAMPS")
                {
                    unsigned value;
                    bool parsed = ParseUnsigned(&value, args[i].argValue);
                    if(!parsed || value > 1)
                        invalidArg = true;
                    else
                    {
                        createArgs.useTimestamps = (LogSetting)value;
                    }
                }
                else if(args[i].argName=="LOG_TO_CONSOLE")
                {
                    unsigned value;
                    bool parsed = ParseUnsigned(&value, args[i].argValue);
                    if(!parsed || value > 1)
                        invalidArg = true;
                    else
                    {
                        createArgs.forwardToConsole = (LogSetting)value;
                    }
                }
                else if(args[i].argName == "SUSPENDED")
                    FileUtility::TryParseBool(args[i], &createArgs.startSuspended);
            }

            if(invalidArg)
                return ParseResult::PARSE_INVALID_ARG;
            else
                return ParseResult::PARSE_SUCCESS;
        }

        bool CommandCreateTask::Execute(unsigned& nextCommand)
        {
            ++nextCommand;
            BuildFormattedName(formattedName, iteratorValues, createArgs.instanceName);
            return Abuse::CreateTask(createArgs);
        }
    }
}
