﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include "BaseTask.h"

#include <nn/socket/socket_api.h>

#include <curl/curl.h>

namespace nnt
{

    namespace abuse
    {

        class CurlStressTask : public BaseTask
        {
        public:
            CurlStressTask(const String& typeName, const String& instanceName);
            virtual ~CurlStressTask();

            virtual InitStatus Initialize(const String& params);
            virtual StartStatus Start();
            virtual RunStatus Run();
            virtual StopStatus Stop();
            virtual ShutdownStatus Shutdown();


        private:
            class CurlEasyContainer
            {
            public:
                CurlEasyContainer();
                ~CurlEasyContainer();

                CURLMcode CurlEasyRegister(CURLM * multiHandle);
                CURLMcode CurlEasyUnregister(CURLM * multiHandle);

                static size_t ReadCallback(char *buffer, size_t size, size_t nitems, void *instream);
                static size_t WriteCallback(char *ptr, size_t size, size_t nmemb, void *userdata);

                bool HasData() const;
                const char * GetData() const;
                int GetDataLenth() const;

            private:
                void* m_curlEasyHandle;
                char* m_receiveBuffer;
                int receivedDataLength;
                bool receivedData;

                CurlStressTask * parent;

            };

            class CurlEasyHashCheck
            {
            public:
                CurlEasyHashCheck();
                ~CurlEasyHashCheck();

                CURLMcode CurlEasyRegister(CURLM * multiHandle);
                CURLMcode CurlEasyUnregister(CURLM * multiHandle);

                static size_t ReadCallback(char *buffer, size_t size, size_t nitems, void *instream);
                static size_t WriteCallback(char *ptr, size_t size, size_t nmemb, void *userdata);



            private:
                void* m_curlEasyHandle;
                char* m_receiveBuffer;
                int receivedDataLength;
                bool receivedData;

                CurlStressTask * parent;

            };


            void *m_curlMultiHandle;

            char * m_receiveBuffer;


        };
    }
}
