﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <nn/os.h>

#include <Platform.h>
#include <AbuseString.h>
namespace nnt
{
    namespace abuse
    {
        //This is used as a mask - only use powers of 2

        enum LogFlushReason
        {
            ReasonBufferFull = 1,
            ReasonErrorWrite = 2,
            ReasonCrash      = 4,
            ReasonLogDeleted = 8,
            ReasonUserRequested = 16,
        };

        enum LogVerbosity
        {
            VerbosityNone = 0,
            VerbosityError,
            VerbosityWarning,
            VerbosityInfo,
            VerbosityVerbose,

            NumVerbosityLevels,
            VerbosityUseGlobal,
        };

        enum LogStreamTypes
        {
            HostFSStream = 0,

        };

        enum LogSetting
        {
            SettingDisabled=0,
            SettingEnabled=1,
            SettingUseGlobal=2
        };

        class Log
        {
        public:
            Log(const String& name, int id, enum LogVerbosity verbosity = VerbosityUseGlobal, int bufSize = DEFAULT_BUFFER_SIZE);
            ~Log();

            static void SetGlobalVerbosity(enum LogVerbosity verbosity);
            static enum LogVerbosity GetGlobalVerbosity();

            static void SetGlobalFlushPolicy(int policy);
            static int GetGlobalFlushPolicy();
            static void SetGlobalForwardToConsole(bool value);
            static void ToggleGlobalTimesamps(bool value);

            void SetForwardToConsole(LogSetting value);
            void SetVerbosity(enum LogVerbosity verbosity);
            enum LogVerbosity GetVerbosity();
            void ToggleTimestamps(LogSetting value);

            void Flush(bool crashing);

            void VWrite(LogVerbosity verbosity, const char* format, va_list args);
            void Write(LogVerbosity verbosity, const char* format, ...);

        private:
            void write(const char* format, va_list args);
            void flush(int reason);
            void flushToFile(char* buffer, int size);
            inline bool shouldWrite(enum LogVerbosity verbosity);
            inline bool shouldConsoleWrite();
            inline bool shouldTimestamp();

            static const int WORK_BUFFER_SIZE;
            static const int DEFAULT_BUFFER_SIZE;
            static bool s_forwardToConsole;
            static bool s_useTimestamps;
            static enum LogVerbosity globalVerbosity;

            char* m_buffer;
            String m_name;

            int   m_id;
            int   m_bufferSize;
            int   m_cursor;
            int   m_flushCursor;

            LogVerbosity m_verbosity;

            nn::os::MutexType m_writeMutex;

            File m_fileHandle;

            String m_filePath;
            bool m_cursorWrapped;
            bool m_fileOpen;
            LogSetting m_forwardToConsole;
            LogSetting m_useTimestamps;
        };
    }
}
