﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/ssl.h>
#include <curl/curl.h>

//---------------------------------------------------------------------------------------------
// HttpsHelperBase class
//---------------------------------------------------------------------------------------------
class HttpsHelperBase
{
public:
    typedef struct VerifyOption
    {
        bool isVerifyPeer;
        bool isVerifyName;
        bool isVerifyTime;
    } VerifyOption;

    HttpsHelperBase(){};
    ~HttpsHelperBase(){};
    int ConfigureVerifyOption(CURL* pInCurlHandle, VerifyOption* pInVerifyOption);

    static bool IsUrlHttps(const char* pInUrl);

protected:
    bool GetSslResultByCurlInfo(
        nn::Result* pOutResult,
        CURL *pInCurlHandle,
        CURLINFO curlInfo);
    void PrintErrorMessage(CURL* pInCurlHandle, nn::Result* pInResult, CURLcode curlError);

    static nn::Result ImportPkiData(nn::ssl::Context* pSslContext);
};

//---------------------------------------------------------------------------------------------
// HttpsHelperForCallback class for CURLOPT_SSL_CTX_FUNCTION method
//---------------------------------------------------------------------------------------------
class HttpsHelperForCallback : public HttpsHelperBase
{
public:
    HttpsHelperForCallback();
    ~HttpsHelperForCallback();
    int  Initialize(CURL *pInCurlHandle);
    void Finalize();
    void PrintErrorMessage(CURL* pInCurlHandle, CURLcode curlError);

    const char* GetServerCertBuffer() const;

    static const uint32_t VerifyResultArrayLen = 4;
    static const uint32_t ServerCertBufLen = 4 * 1024;

private:
    nn::Result m_Result; //<! nn::Result to store Result in CURLOPT_SSL_CTX_FUNCTION
    char* m_pServerCertBuf;

    static size_t CurlSslContextCallback(CURL* pCurl, void* pSslContext, void* pUserData);
    static size_t CurlSslConnectionBeforeFunction(CURL* pCurl, void *pSslConnection, void *pUserData);
    static size_t CurlSslConnectionAfterFunction(CURL* pCurl, void *pSslConnection, void *pUserData, curl_handshake_info handshakeInfo);
};

//---------------------------------------------------------------------------------------------
// HttpsHelperForCtxImport class for CURLOPT_SSL_CONTEXT method
//---------------------------------------------------------------------------------------------
class HttpsHelperForCtxImport : public HttpsHelperBase
{
public:
    HttpsHelperForCtxImport();
    ~HttpsHelperForCtxImport();
    int  Initialize();
    void Finalize();
    int  ImportSslContext(CURL* pInCurlHandle);
    void PrintErrorMessage(CURL* pInCurlHandle, CURLcode curlError);

private:
    nn::ssl::Context* m_pSslContext; //<! Pointer to the nn::ssl::Context shared by multiple CURL handles
};

