/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

    .section ".rtld.init", "ax";
    .align  2;
    .global  _start;
    .type   _start, %function;

_start:
    mov lr, #0

    // In case of exception, the thread switches to stack=somewhere in the TLR, x0=cause, PC=_start. We need to tell the kernel that we do not handle it to trigger the abort handler
    cmp     r0, #0
    beq     NoException;

    ldr     r0, =0x27c // TODO: NotHandled
    bl      _ZN2nn3svc7aarch3219ReturnFromExceptionENS_6ResultE
0:  b       0b

NoException:
    // clear bss
    bl      2f
1:  .word   __bss_start - 1b
2:  ldr     r0, [lr]
    add     r0, r0, lr

    bl      2f
1:  .word   __bss_end - 1b
2:  ldr     r1, [lr]
    add     r1, r1, lr
    sub     r1, r1, r0

    bl      nntSvcFwkLdrClearBss

    // get load base address
    bl      2f
1:  .word   _start - 1b
2:  ldr     r0, [lr]
    add     r0, r0, lr  // r0 <- load base address

    // From rtld.aarch64.lp64.S
    // get .dynamic address
    //  r0 <- load base address
    bl      2f
1:  .word   _DYNAMIC - 1b
2:  ldr     r1, [lr]
    add     r1, r1, lr  //  r1 <- .dynamic address


    // r0 <- load base address
    // r1 <- .dynamic address
    bl      nntSvcFwkLdrRelocate

    bl       nntSvcFwkLdrCallConstructors
    bl       nnMain
  
    b       nntSvcFwkLdrExit