﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "sdmmc_BaseDevice.h"
#include <nn/nn_Abort.h>
#include "sdmmc_Log.h"

namespace nn { namespace sdmmc1 {
namespace detail {

namespace
{
    // TODO: 値が正しいか怪しい、ライブラリ共有の場所で定義すべき
    const uint32_t SystemFrequencyKHz = 696000;

    void SpinWaitCpuCycles(uint64_t cycle) NN_NOEXCEPT
    {
        // TODO: アセンブラで適切な cycle 数をスピンするように変更予定
        // 9 = ldrd 1 + subs 1 + sbc 1 + strd 1 + ldrd 1 + orrs 1 + bne 3
        volatile uint64_t loopCount = cycle / 9;
        do
        {
            loopCount--;
        } while (loopCount > 0);
    }

}

void WaitMicroseconds(uint32_t us) NN_NOEXCEPT
{
    SpinWaitCpuCycles(static_cast<uint64_t>(us) * SystemFrequencyKHz / 1000);
}

void WaitClocks(uint32_t numClocks, uint32_t clockFrequencyKHz) NN_NOEXCEPT
{
    NN_ABORT_UNLESS(SystemFrequencyKHz >= clockFrequencyKHz);
    SpinWaitCpuCycles(static_cast<uint64_t>(numClocks) * SystemFrequencyKHz / clockFrequencyKHz / 1000);
}

} // namespace detail {
}} // namespace nn { namespace sdmmc1 {
