﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "sdmmc_BaseDevice.h"

namespace nn { namespace sdmmc1 {
namespace detail {

class SdCardDevice : public BaseDevice
{
private:
    uint32_t m_Ocr;
    uint32_t m_Cid[4];
    uint32_t m_Csd[4];

    Result IssueCommandSendIfCond() const NN_NOEXCEPT;
    Result IssueCommandSendOpCond(uint32_t* pOutOcr, uint8_t hcs) const NN_NOEXCEPT;
    Result IssueCommandSendRelativeAddr(uint16_t* pOutRca) const NN_NOEXCEPT;
    Result IssueCommandAppCmd(uint16_t rca, DeviceState expectedState) const NN_NOEXCEPT;

public:
    virtual void Initialize(IHostController* pHostController) NN_NOEXCEPT NN_OVERRIDE
    {
        BaseDevice::Initialize(pHostController, IDevice::DeviceType_SdCard);
    }
    virtual Result Activate() NN_NOEXCEPT NN_OVERRIDE;


};

} // namespace detail {
}} // namespace nn { namespace sdmmc1 {
