﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/svc/svc_Server.h>
#include <nn/svc/svc_MemoryMapSelect.h>
#include <nn/svc/svc_MemoryConfigSelect.h>

#include "test_TestSvc.h"
#include "util_KipFormat.h"

const uint64_t PageSize = 4096;
const uint64_t LoadAlign = 0x00200000;

inline size_t SizeToPage(uint64_t s)
{
    return (s + PageSize - 1) / PageSize;
}
inline uint64_t PageToSize(size_t p)
{
    return p * PageSize;
}

class ProcessImageMemory
{
    private:
        void*   m_pEx;
        void*   m_pRo;
        void*   m_pRw;
        uint64_t  m_ExSize;
        uint64_t  m_RoSize;
        uint64_t  m_RwSize;
        int64_t m_MapSize;

    public:
        explicit ProcessImageMemory()
            : m_pEx(NULL), m_pRo(NULL), m_pRw(NULL),
            m_ExSize(0), m_RoSize(0), m_RwSize(0), m_MapSize(0)
        {
        }

        ~ProcessImageMemory()
        {
        }

        void LoadImage(
                nn::svc::Handle handle, const char *pFile, size_t fileSize,
                const KipFormat& kip, uint64_t base);
        void SetPermission(
                nn::svc::Handle handle, const KipFormat& kip, uint64_t base);
        int64_t GetMapSize() const
        {
            return m_MapSize;
        }
        void Unmap(nn::svc::Handle handle, const KipFormat& kip, uint64_t base);

    private:
        void Map(nn::svc::Handle handle, const KipFormat& kip, uint64_t base);
};

