﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/svc/svc_Tcb.h>

#include "util_KipFormat.h"

namespace {
const size_t ArgumentSize = ((sizeof(int32_t) * 2 + 32 * 1024) + 0xfff) & 0xfff;
const int NumKipCapability = 0x80 / sizeof(nn::Bit32);
}


void ReadKipHeader(KipFormat * pOut, const char* pFile, size_t fileSize);
size_t GetMemorySize(const KipFormat& kip);
void MakeProcessParameter(
        nn::svc::CreateProcessParameter* pHeader, const KipFormat& kip,
        uint64_t base, size_t size);

