﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Tcb.h>
#include <cstring>
#include <nn/svc/svc_BaseId.autogen.h>

namespace {
}
extern "C" void nnMain();


// TEST 123-1
// 終了済みプロセスに対して TerminateProcess
TEST(TerminateProcess, Test0)
{
    TestProcessLeak leakTest;
    nn::Result result;
    nn::svc::Handle handle;
    nn::svc::CreateProcessParameter param = {};

    for (int i = 0; i < 1000; i++)
    {
        for (int coreNo = 0; coreNo < NumCore; coreNo++)
        {
            bool is64Bit = false;
            int pri = TestHighestThreadPriority;
            std::strncpy(param.name, "test", sizeof(param.name));
            param.version        = 0xbabeface;
            param.programId      = 0xdeadbeef0badcafeull;
            param.memoryAddress  = 0x00200000;
            param.memoryNumPages = 1;
            param.flags          = 0x00000000;

            nn::Bit32 flags[DefaultCapabilityFlagNum];
            SetDefaultCapability(flags, DefaultCapabilityFlagNum);
            result = nn::svc::CreateProcess(&handle, param, flags, DefaultCapabilityFlagNum);
            ASSERT_RESULT_SUCCESS(result);

            {
                result = nn::svc::MapProcessMemory(g_FreeAreaBegin, static_cast<nn::svc::Handle>(handle), param.memoryAddress, param.memoryNumPages * 0x1000);
                ASSERT_RESULT_SUCCESS(result);

                *reinterpret_cast<uint32_t*>(g_FreeAreaBegin) = (is64Bit?(0xd4000001 | (NN_SVC_ID_EXIT_PROCESS << 5)):(0xef000000 | NN_SVC_ID_EXIT_PROCESS));

                result = nn::svc::UnmapProcessMemory(g_FreeAreaBegin, static_cast<nn::svc::Handle>(handle), param.memoryAddress, param.memoryNumPages * 0x1000);
                ASSERT_RESULT_SUCCESS(result);

                result = nn::svc::SetProcessMemoryPermission(static_cast<nn::svc::Handle>(handle), param.memoryAddress, param.memoryNumPages * 0x1000, nn::svc::MemoryPermission_ReadExecute);
                ASSERT_RESULT_SUCCESS(result);
            }

            result = nn::svc::StartProcess(handle, pri, coreNo, 0x1000);
            ASSERT_RESULT_SUCCESS(result);

            int32_t index;
            result = nn::svc::WaitSynchronization(&index, &handle, 1, -1);
            ASSERT_RESULT_SUCCESS(result);

            result = nn::svc::TerminateProcess(handle);
            ASSERT_RESULT_SUCCESS(result);

            result = nn::svc::CloseHandle(handle);
            ASSERT_RESULT_SUCCESS(result);
            // worker threadが後始末をするためのwait
            nn::svc::SleepThread(10 * 1000 * 1000);
        }
    }
}

// TEST 123-2
// 実行中プロセスに対して TerminateProcess
TEST(TerminateProcess, Test1)
{
    TestProcessLeak leakTest;
    nn::Result result;
    nn::svc::Handle handle;
    nn::svc::CreateProcessParameter param = {};

    int32_t pri = TestHighestThreadPriority;
    result = nn::svc::SetThreadPriority(static_cast<nn::svc::Handle>(0xFFFF8000), pri);
    ASSERT_RESULT_SUCCESS(result);
    pri++;

    for (int i = 0; i < 1000; i++)
    {
        for (int coreNo = 0; coreNo < NumCore; coreNo++)
        {
            bool is64Bit = false;
            std::strncpy(param.name, "test", sizeof(param.name));
            param.version        = 0xbabeface;
            param.programId      = 0xdeadbeef0badcafeull;
            param.memoryAddress  = 0x00200000;
            param.memoryNumPages = 1;
            param.flags          = 0x00000000;

            nn::Bit32 flags[DefaultCapabilityFlagNum];
            SetDefaultCapability(flags, DefaultCapabilityFlagNum);
            result = nn::svc::CreateProcess(&handle, param, flags, DefaultCapabilityFlagNum);
            ASSERT_RESULT_SUCCESS(result);

            {
                result = nn::svc::MapProcessMemory(g_FreeAreaBegin, static_cast<nn::svc::Handle>(handle), param.memoryAddress, param.memoryNumPages * 0x1000);
                ASSERT_RESULT_SUCCESS(result);

                // 自分自身へのブランチ命令
                *reinterpret_cast<uint32_t*>(g_FreeAreaBegin) = (is64Bit?0x14000000:0xeafffffe);

                result = nn::svc::UnmapProcessMemory(g_FreeAreaBegin, static_cast<nn::svc::Handle>(handle), param.memoryAddress, param.memoryNumPages * 0x1000);
                ASSERT_RESULT_SUCCESS(result);

                result = nn::svc::SetProcessMemoryPermission(static_cast<nn::svc::Handle>(handle), param.memoryAddress, param.memoryNumPages * 0x1000, nn::svc::MemoryPermission_ReadExecute);
                ASSERT_RESULT_SUCCESS(result);
            }

            result = nn::svc::StartProcess(handle, pri, coreNo, 0x1000);
            ASSERT_RESULT_SUCCESS(result);

            nn::svc::SleepThread(10 * 1000 * 1000);

            result = nn::svc::TerminateProcess(handle);
            ASSERT_RESULT_SUCCESS(result);

            int32_t index;
            result = nn::svc::WaitSynchronization(&index, &handle, 1, -1);
            ASSERT_RESULT_SUCCESS(result);

            result = nn::svc::CloseHandle(handle);
            ASSERT_RESULT_SUCCESS(result);

            // worker threadが後始末をするためのwait
            nn::svc::SleepThread(10 * 1000 * 1000);
        }
    }
}

