﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include "test_SharedMemory.h"
#include "util_TestLoader.h"
#include <nn/nn_Assert.h>
#include <nn/svc/svc_Dd.h>
#include <nn/svc/svc_Dmnt.h>
#include <nn/svc/svc_Tcb.h>
#include <nn/svc/ipc/svc_SessionMessage.h>
#include <cstring>

namespace {

void ReplyAck(nn::svc::ipc::MessageBuffer& ipcMsg, nn::svc::Handle serverSession)
{
    nn::Result result;
    int32_t index;
    ipcMsg.SetNull();
    result = nn::svc::ReplyAndReceive(
                &index, &serverSession, 0, serverSession, 0);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultTimeout());
}

} // namespace

extern char BinSharedMemory_begin[];
extern char BinSharedMemory_end[];

TEST(SharedMemory, OtherPermissionTest)
{
    nn::Result result;
    nn::svc::Handle serverPort;
    nn::svc::Handle serverSession;
    nn::Bit32* pMsgBuffer;
    int32_t index;

    /*
       前準備
     */

    uintptr_t begin = reinterpret_cast<uintptr_t>(BinSharedMemory_begin);
    uintptr_t end = reinterpret_cast<uintptr_t>(BinSharedMemory_end);
    TestLoader loader(BinSharedMemory_begin, end - begin);

    // 共有メモリを作成
    const int HandleNum = 3;
    nn::svc::Handle handles[HandleNum];
    nn::svc::MemoryPermission validPermission[] = {
        nn::svc::MemoryPermission_DontCare,
        nn::svc::MemoryPermission_ReadWrite,
        nn::svc::MemoryPermission_Read,
    };
    for (int32_t i = 0; i < HandleNum; i++)
    {
        result = nn::svc::CreateSharedMemory(
                &handles[i], SharedSize,
                nn::svc::MemoryPermission_ReadWrite, validPermission[i]);
        ASSERT_RESULT_SUCCESS(result);
    }

    // 名前付きポートの設定
    result = nn::svc::ManageNamedPort(&serverPort, PortName, 1);
    ASSERT_RESULT_SUCCESS(result);
    AutoHandleClose portCloser(serverPort);

    nn::svc::Handle process;
    loader.SpawnProcess(&process);
    loader.StartProcess(process);
    AutoHandleClose processCloser(process);

    // IPC の設定
    pMsgBuffer = nn::svc::ipc::GetMessageBuffer();
    nn::svc::ipc::MessageBuffer ipcMsg(pMsgBuffer);

    // クライアントを待つ
    // 一つのプロセスしか待たない
    NN_LOG("Wait connection\n");
    result = nn::svc::WaitSynchronization(&index, &serverPort, 1, -1);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::AcceptSession(&serverSession, serverPort);
    ASSERT_RESULT_SUCCESS(result);
    AutoHandleClose sSessionCloser(serverSession);

    NN_LOG("Accept session\n");

    // クライアントの要求を受け付ける
    {
        ipcMsg.SetNull();
        result = nn::svc::ReplyAndReceive(
                &index, &serverSession, 1, nn::svc::INVALID_HANDLE_VALUE, -1);
        ASSERT_RESULT_SUCCESS(result);
    }


    // ハンドルを送信
    {
        nn::svc::ipc::MessageBuffer::MessageHeader ipcHeader(0x0001, 1, 0, 0, 0, 0, 0, 0);
        ipcMsg.Set(ipcHeader);
        ASSERT_TRUE(HandleNum == 3);
        nn::svc::ipc::MessageBuffer::SpecialHeader ipcSpecial(false, 0, 3); // Copy: 0, Move: 3
        int offset = ipcMsg.Set(ipcHeader);
        offset = ipcMsg.Set(ipcSpecial);

        for (int32_t i = 0; i < HandleNum; i++)
        {
            offset = ipcMsg.SetHandle(offset, handles[i]); // Move
        }

        result = nn::svc::ReplyAndReceive(
                &index, &serverSession, 1, serverSession, -1);
        ASSERT_RESULT_SUCCESS(result);
    }

    // 終了処理
    ReplyAck(ipcMsg, serverSession);

    result = nn::svc::ManageNamedPort(&serverPort, PortName, 0);
    ASSERT_RESULT_SUCCESS(result);

    WaitProcess(process);

    NN_LOG("*** Pass MapSharedMemory Test ***\n");
}

