﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"

extern nn::Result ClientSendLightRequest(nn::svc::Handle handle);
extern nn::Result ServerReceiveLightRequest(nn::svc::Handle handle);
extern nn::Result ServerReplyLightRequest(nn::svc::Handle handle);

namespace {
} // namespace

TEST(ReplyAndReceiveLight, HandleTest)
{
    TestLightSessionLeak leakTest;
    nn::Result result;
    nn::svc::Handle serverPort;
    nn::svc::Handle clientPort;
    nn::svc::Handle serverSession;
    nn::svc::Handle clientSession;
    int32_t index;

    // TEST 66-8
    // INVALID_HANDLE_VALUE を受け付けない
    result = ServerReceiveLightRequest(nn::svc::INVALID_HANDLE_VALUE);
    ASSERT_RESULT_FAILURE(result);

    // TEST 66-9
    // スレッドの擬似ハンドルは受け付けない
    result = ServerReceiveLightRequest(nn::svc::PSEUDO_HANDLE_CURRENT_THREAD);
    ASSERT_RESULT_FAILURE(result);

    // TEST 66-10
    // プロセスの擬似ハンドルは受け付けない
    result = ServerReceiveLightRequest(nn::svc::PSEUDO_HANDLE_CURRENT_PROCESS);
    ASSERT_RESULT_FAILURE(result);


    // TEST 66-11
    // NamedPort の Normal Session は受け付けない
    {
        const char* portName = "lightTest";
        result = nn::svc::ManageNamedPort(&serverPort, portName, 1);
        ASSERT_RESULT_SUCCESS(result);
        AutoHandleClose sPortCloser(serverPort);

        result = nn::svc::ConnectToNamedPort(&clientSession, portName);
        ASSERT_RESULT_SUCCESS(result);
        AutoHandleClose cSessionCloser(clientSession);

        result = nn::svc::WaitSynchronization(&index, &serverPort, 1, 0);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::AcceptSession(&serverSession, serverPort);
        ASSERT_RESULT_SUCCESS(result);
        AutoHandleClose sSessionCloser(serverSession);

        result = ServerReceiveLightRequest(serverPort);
        ASSERT_RESULT_FAILURE(result);

        result = ServerReceiveLightRequest(clientSession);
        ASSERT_RESULT_FAILURE(result);

        result = ServerReceiveLightRequest(serverSession);
        ASSERT_RESULT_FAILURE(result);

        result = nn::svc::ManageNamedPort(&serverPort, portName, 0);
        ASSERT_RESULT_SUCCESS(result);
    }

    // TEST 66-12
    // Port の Normal Session は受け付けない
    {
        result = nn::svc::CreatePort(&serverPort, &clientPort, 1, false, 1);
        ASSERT_RESULT_SUCCESS(result);
        AutoHandleClose sPortCloser(serverPort);
        AutoHandleClose cPortCloser(clientPort);

        result = nn::svc::ConnectToPort(&clientSession, clientPort);
        ASSERT_RESULT_SUCCESS(result);
        AutoHandleClose cSessionCloser(clientSession);

        result = nn::svc::WaitSynchronization(&index, &serverPort, 1, 0);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::AcceptSession(&serverSession, serverPort);
        ASSERT_RESULT_SUCCESS(result);
        AutoHandleClose sSessionCloser(serverSession);

        result = ServerReceiveLightRequest(serverPort);
        ASSERT_RESULT_FAILURE(result);

        result = ServerReceiveLightRequest(clientPort);
        ASSERT_RESULT_FAILURE(result);

        result = ServerReceiveLightRequest(clientSession);
        ASSERT_RESULT_FAILURE(result);

        result = ServerReceiveLightRequest(serverSession);
        ASSERT_RESULT_FAILURE(result);
    }

    // TEST 66-13
    // Session の Normal Session は受け付けない
    {
        result = nn::svc::CreateSession(&serverSession, &clientSession, false, 1);
        ASSERT_RESULT_SUCCESS(result);
        AutoHandleClose sSessionCloser(serverSession);
        AutoHandleClose cSessionCloser(clientSession);

        result = ServerReceiveLightRequest(clientSession);
        ASSERT_RESULT_FAILURE(result);

        result = ServerReceiveLightRequest(serverSession);
        ASSERT_RESULT_FAILURE(result);
    }

    {
        result = nn::svc::CreateSession(&serverSession, &clientSession, true, 1);
        ASSERT_RESULT_SUCCESS(result);
        AutoHandleClose sSessionCloser(serverSession);
        AutoHandleClose cSessionCloser(clientSession);

        // TEST 66-15
        // クライアントセッションは受け付けない
        result = ServerReplyLightRequest(clientSession);
        ASSERT_RESULT_FAILURE(result);

        result = sSessionCloser.Close();
        ASSERT_RESULT_SUCCESS(result);

        // TEST 66-14
        // 閉じられたセッションは受け付けない
        result = ServerReplyLightRequest(serverSession);
        ASSERT_RESULT_FAILURE(result);
    }
}

