﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Result.h>
#include <nn/svc/svc_Thread.h>
#include <nn/svc/svc_HardwareParamsSelect.h>

namespace {

const size_t StackSize = 0x2000;
const int32_t NumPriority = TestLowestThreadPriority - TestHighestThreadPriority + 1;

void TestThread0(uintptr_t arg)
{
    AutoThreadExit autoExit;
    nn::Result result;
    int32_t priority;

    result = nn::svc::GetThreadPriority(&priority, nn::svc::PSEUDO_HANDLE_CURRENT_THREAD);
    ASSERT_RESULT_SUCCESS(result);
    ASSERT_TRUE(static_cast<int32_t>(arg) == priority);
}

} // namespace

/* TEST 10-7 */
/* 複数のスレッドで、正しく優先度を取得できるかをチェックする */
TEST(GetThreadPriorityTest, MultiThreadsTest)
{
    TestThreadLeak leakTest;
    nn::svc::Handle *handle;
    nn::Result result;
    int32_t priority;
    int32_t idealCore;
    uintptr_t sp;
    uintptr_t pc;
    uintptr_t heapPtr;
    size_t heapSize;
    size_t wantSize = StackSize * NumPriority + sizeof(nn::svc::Handle) * NumPriority;

    heapSize = (HeapAlign >= wantSize) ?
        HeapAlign : (wantSize + HeapAlign - 1) & ~(HeapAlign - 1);
    result = nn::svc::SetHeapSize(&heapPtr, heapSize);
    ASSERT_RESULT_SUCCESS(result);

    pc = reinterpret_cast<uintptr_t>(TestThread0);
    handle = reinterpret_cast<nn::svc::Handle*>(heapPtr);

    for (idealCore = 0; idealCore < NumCore; idealCore++)
    {
        for (priority = TestHighestThreadPriority;
                priority <= TestLowestThreadPriority; priority++)
        {
            sp = reinterpret_cast<uintptr_t>
                (heapPtr + heapSize - (StackSize * (priority - TestHighestThreadPriority)));
            result = nn::svc::CreateThread(&handle[priority], pc, priority, sp, priority, idealCore);
            ASSERT_RESULT_SUCCESS(result);

            result = nn::svc::StartThread(handle[priority]);
            ASSERT_RESULT_SUCCESS(result);
        }

        for (priority = TestHighestThreadPriority;
                priority <= TestLowestThreadPriority; priority++)
        {
            int32_t index;
            result = nn::svc::WaitSynchronization(&index, &handle[priority], 1, -1);
            ASSERT_RESULT_SUCCESS(result);

            result = nn::svc::CloseHandle(handle[priority]);
            ASSERT_RESULT_SUCCESS(result);
        }
    }

    result = nn::svc::SetHeapSize(&heapPtr, 0);
    ASSERT_RESULT_SUCCESS(result);
}

