﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Thread.h>

namespace {
char g_Buffer[DefaultStackSize] __attribute__((aligned(0x1000)));
}

void TestExitThreadFunction0(uintptr_t arg)
{
    NN_UNUSED(arg);
    nn::svc::ExitThread();
    ASSERT_TRUE(false);
}

/* TEST 8-1 */
/* ExitThread が呼ばれた時点で終了するかを調べる*/
TEST(ExitThreadTest, Test0)
{
    TestThreadLeak leakTest;
    nn::Result result;
    nn::svc::Handle handle;
    int32_t idealCore;
    int32_t priority;
    uintptr_t sp;
    uintptr_t pc;
    int32_t index;

    sp = reinterpret_cast<uintptr_t>(g_Buffer + sizeof(g_Buffer));
    pc = reinterpret_cast<uintptr_t>(TestExitThreadFunction0);

    for (idealCore = 0; idealCore < NumCore; idealCore++)
    {
        for (priority = TestHighestThreadPriority;
                priority <= TestLowestThreadPriority; priority++)
        {
            result = nn::svc::CreateThread(&handle, pc, 0, sp, priority, idealCore);
            ASSERT_RESULT_SUCCESS(result);

            result = nn::svc::StartThread(handle);
            ASSERT_RESULT_SUCCESS(result);

            result = nn::svc::WaitSynchronization(&index, &handle, 1, -1);
            ASSERT_RESULT_SUCCESS(result);

            result = nn::svc::CloseHandle(handle);
            ASSERT_RESULT_SUCCESS(result);
        }
    }
}

