﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include "test_DASProcess.h"
#include "util_TestIpc.h"
#include <nn/nn_Assert.h>
#include <nn/svc/ipc/svc_SessionMessage.h>
#include <nn/nn_BitTypes.h>
#include <cstring>
#include <nn/init.h>

#if defined (NN_BUILD_CONFIG_HARDWARE_JETSONTK1) || (NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || defined (NN_BUILD_CONFIG_HARDWARE_NX)
#include "util_TestSdmmc.h"
namespace {
    // const nn::sdmmc1::Port TestPort = nn::sdmmc1::Port_Mmc0;    // sdmmc4a
    const nn::sdmmc1::Port TestPort = nn::sdmmc1::Port_SdCard0; // sdmmc3a

    const uint32_t TestSectorIndex = 0;
    const uint32_t TestSize = 32 * 1024;
}
#endif


extern "C" void nndiagStartup()
{
}

extern "C" void nninitStartup()
{
}

uintptr_t g_HeapAreaBegin;
uintptr_t g_HeapAreaEnd;
uintptr_t g_ReservedAreaBegin;
uintptr_t g_ReservedAreaEnd;
uintptr_t g_FreeAreaBegin;
uintptr_t g_FreeAreaEnd;

extern "C" void nnMain()
{
#if defined (NN_BUILD_CONFIG_HARDWARE_JETSONTK1) || (NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || defined (NN_BUILD_CONFIG_HARDWARE_NX)

    InitTestMemory();
    nn::Result result;
    nn::svc::Handle clientSession;

    result = nn::svc::ConnectToNamedPort(&clientSession, PortName);
    NN_ASSERT_RESULT_SUCCESS(result);

    nn::svc::Handle readableHandle;
    ReceiveMoveHandleFromServer(&readableHandle, clientSession);
    AutoHandleClose rEventCloser(readableHandle);

    nn::svc::Handle dasHandle;
    ReceiveCopyHandleFromServer(&dasHandle, clientSession);
    AutoHandleClose dasCloser(dasHandle);

    int32_t index = 0;
    result = nn::svc::WaitSynchronization(&index, &readableHandle, 1, -1);
    NN_ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::ResetSignal(readableHandle);
    NN_ASSERT_RESULT_SUCCESS(result);

    {
        size_t align = 0x400000;
        uint64_t deviceAddress = 0x400000;

        size_t heapSize = align * 3;
        TestHeap heap(heapSize);
        NN_ASSERT(heapSize == heap.GetSize());
        uintptr_t heapAddr = (heap.GetAddress() + (align - 1)) & ~(align - 1);

        nn::svc::PhysicalMemoryInfo physInfo = { 0 };
        result = nn::svc::QueryPhysicalAddress(&physInfo, heapAddr);
        NN_ASSERT_RESULT_SUCCESS(result);
        // 4MBアラインされるはず
        uintptr_t physAddr = physInfo.physicalAddress + (heapAddr - physInfo.virtualAddress);
        NN_ASSERT((physAddr & (align - 1)) == 0);

        heapSize -= heapAddr - heap.GetAddress();

        // まだ他のプロセスがマップしている
        result = nn::svc::MapDeviceAddressSpaceByForce(
                dasHandle, nn::svc::PSEUDO_HANDLE_CURRENT_PROCESS,
                heapAddr, TestSize, deviceAddress,
                nn::svc::MemoryPermission_ReadWrite);
        NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCurrentMemory());

        // 送るデータは何でもいい
        ClientSendData(clientSession, &heapAddr, sizeof(heapAddr));

        result = nn::svc::WaitSynchronization(&index, &readableHandle, 1, -1);
        NN_ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::MapDeviceAddressSpaceByForce(
                dasHandle, nn::svc::PSEUDO_HANDLE_CURRENT_PROCESS,
                heapAddr, TestSize, deviceAddress,
                nn::svc::MemoryPermission_ReadWrite);
        NN_ASSERT_RESULT_SUCCESS(result);

        nn::svc::MemoryInfo blockInfo;
        GetMemoryInfo(&blockInfo, heapAddr);
        NN_ASSERT(blockInfo.state == nn::svc::MemoryState_Normal);
        NN_ASSERT(blockInfo.permission == nn::svc::MemoryPermission_ReadWrite);
        NN_ASSERT(blockInfo.attribute == nn::svc::MemoryAttribute_DeviceShared);
        NN_ASSERT(blockInfo.deviceCount == 1);

        char* buffer = reinterpret_cast<char*>(heapAddr);
        size_t msgSize = std::strlen(TestMessage) + 1;
        uint32_t numSectors = msgSize / nn::sdmmc1::SectorSize;
        if (numSectors == 0)
        {
            msgSize = nn::sdmmc1::SectorSize;
            numSectors = 1;
        }

        {
            Sdmmc sdmmc(buffer, TestSize, deviceAddress, TestPort);
            NN_ASSERT(sdmmc.Activate());

            nn::sdmmc1::Read(buffer, msgSize, TestPort, TestSectorIndex, numSectors);
            NN_ASSERT(::strcmp(TestMessage, buffer) == 0);
        }

        result = nn::svc::UnmapDeviceAddressSpace(
                dasHandle, nn::svc::PSEUDO_HANDLE_CURRENT_PROCESS,
                heapAddr, TestSize, deviceAddress);
        NN_ASSERT_RESULT_SUCCESS(result);

        GetMemoryInfo(&blockInfo, heapAddr);
        NN_ASSERT(blockInfo.state == nn::svc::MemoryState_Normal);
        NN_ASSERT(blockInfo.permission == nn::svc::MemoryPermission_ReadWrite);
        NN_ASSERT(blockInfo.attribute == 0);
        NN_ASSERT(blockInfo.deviceCount == 0);

    }

#endif // (NN_BUILD_CONFIG_HARDWARE_JETSONTK1) || (NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || defined (NN_BUILD_CONFIG_HARDWARE_NX)
} // NOLINT(readability/fn_size)


