﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_TestIoMapping.h"
#include "test_Common.h"
#include "util_TestProcess.h"
#include "test_TestTmrDevice_Jetson.h"
#include <nn/svc/svc_Dd.h>
#include <cstring>

namespace {
} // namespace

TEST(CreateProcess, IoMappingPermissionTest)
{
    TestProcessLeak testProcessLeak;
    nn::Result result;
    uintptr_t addr;
    nn::svc::PhysicalAddress phyAddr = 0x60020000; // APB-DMA
    size_t size = 0x1000;
    nn::svc::MemoryInfo blockInfo;
    nn::svc::PageInfo pageInfo;

    // TEST 121-120
    // No.6 に指定した Read 領域に対して、読み込みが許可されている
    result = nn::svc::QueryIoMapping(&addr, phyAddr, size);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::QueryMemory(&blockInfo, &pageInfo, addr);
    ASSERT_RESULT_SUCCESS(result);
    ASSERT_TRUE(blockInfo.baseAddress <= addr);
    ASSERT_TRUE(blockInfo.baseAddress + blockInfo.size >= addr + size);
    ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Io);
    ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_Read);
    TEST_RO(addr);

    // TEST 121-121
    // No.6 に指定した ReadWrite 領域に対して、読み込みと書き込みが許可されている
    phyAddr = TmrPhysicalBaseAddr;

    result = nn::svc::QueryIoMapping(&addr, phyAddr, size);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::QueryMemory(&blockInfo, &pageInfo, addr);
    ASSERT_RESULT_SUCCESS(result);
    ASSERT_TRUE(blockInfo.baseAddress <= addr);
    ASSERT_TRUE(blockInfo.baseAddress + blockInfo.size >= addr + size);
    ASSERT_TRUE(blockInfo.state == nn::svc::MemoryState_Io);
    ASSERT_TRUE(blockInfo.permission == nn::svc::MemoryPermission_ReadWrite);

    volatile nn::Bit32* reg = reinterpret_cast<nn::Bit32*>(addr);
    nn::Bit32 tmp = *reg;
    *reg = tmp + 1;
    ASSERT_TRUE(*reg == tmp + 1);
    *reg = tmp;
}

